/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice;

import cn.com.duiba.goods.center.api.remoteservice.front.RemoteGoodsConsumerService;
import cn.com.duiba.goods.center.biz.entity.GoodsLimitRecordEntity;
import cn.com.duiba.goods.center.biz.remoteservice.pcg.RemoteGoodsBatchServiceImpl;
import cn.com.duiba.goods.center.biz.service.GoodsLimitRecordService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteGoodsConsumerService")
public class RemoteGoodsConsumerServiceImpl
implements RemoteGoodsConsumerService {
    private static Logger log = LoggerFactory.getLogger(RemoteGoodsBatchServiceImpl.class);
    @Autowired
    private GoodsLimitRecordService goodsLimitRecordService;

    public DubboResult<Integer> findConsumerExchangeCount2(int gtype, long gid, long consumerId) {
        try {
            int count = this.goodsLimitRecordService.findCount(gtype, gid, consumerId);
            return DubboResult.successResult((Object)count);
        }
        catch (Exception e) {
            log.error("findConsumerExchangeCount gtype=" + gtype + ",gid=" + gid + ",consumerId=" + consumerId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Map<Long, Integer>> findConsumerExchangeCounts(int gtype, List<Long> gids, long consumerId) {
        try {
            if (gids.isEmpty()) {
                HashMap map = new HashMap();
                return DubboResult.successResult(map);
            }
            List<GoodsLimitRecordEntity> list = this.goodsLimitRecordService.findCounts(gtype, gids, consumerId);
            HashMap<Long, Integer> map = new HashMap<Long, Integer>();
            for (GoodsLimitRecordEntity glre : list) {
                map.put(glre.getGid(), glre.getCount());
            }
            return DubboResult.successResult(map);
        }
        catch (Exception e) {
            log.error("findConsumerExchangeCounts gtype=" + gtype + ",consumerId=" + consumerId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public Integer findConsumerExchangeCount(int gtype, long gid, long consumerId) {
        return this.goodsLimitRecordService.findCount(gtype, gid, consumerId);
    }
}

