/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.RemoteGoodsDirectionalConfigBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsDirectionalConfigDto;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteGoodsDirectionalConfigBackendServiceImpl
implements RemoteGoodsDirectionalConfigBackendService {
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    @Autowired
    private RemoteStockBackendService remoteStockBackendService;
    private static Logger log = LoggerFactory.getLogger(RemoteGoodsDirectionalConfigBackendServiceImpl.class);

    public DubboResult<GoodsDirectionalConfigDto> find(Long id) {
        if (id == null) {
            return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdnull");
        }
        GoodsDirectionalConfigEntity entity = this.goodsDirectionalConfigService.find(id);
        if (entity == null) {
            return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdnull");
        }
        GoodsDirectionalConfigDto dto = this.entityToDto(entity);
        return DubboResult.successResult((Object)dto);
    }

    public DubboResult<List<GoodsDirectionalConfigDto>> findByGoods(GoodsTypeEnum gtype, Long goodsId) {
        try {
            if (gtype == null || goodsId == null) {
                return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdnull");
            }
            ArrayList<GoodsDirectionalConfigDto> dtos = new ArrayList<GoodsDirectionalConfigDto>();
            List<GoodsDirectionalConfigEntity> entities = this.goodsDirectionalConfigService.findByGoods(gtype, goodsId);
            if (entities != null) {
                for (GoodsDirectionalConfigEntity entity : entities) {
                    dtos.add(this.entityToDto(entity));
                }
            }
            return DubboResult.successResult(dtos);
        }
        catch (Exception e) {
            log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\n", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> add(List<GoodsDirectionalConfigDto> list) {
        try {
            if (list == null || list.size() == 0) {
                return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            for (GoodsDirectionalConfigDto dto : list) {
                GoodsDirectionalConfigEntity entity = this.dtoToEntity(dto);
                Long stockId = this.getStockId(dto.getGoodsId(), dto.getStockChange());
                entity = this.dtoToEntity(dto);
                entity.setStockId(stockId);
                this.goodsDirectionalConfigService.add(entity);
            }
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> delete(Long id) {
        try {
            if (id == null) {
                return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            boolean rs = this.goodsDirectionalConfigService.remove(id);
            if (rs) {
                return DubboResult.successResult((Object)true);
            }
            if (this.goodsDirectionalConfigService.find(id) != null) {
                return DubboResult.successResult((Object)true);
            }
            return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        catch (Exception e) {
            log.error("delete,error,", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> update(List<GoodsDirectionalConfigDto> list) {
        try {
            if (list == null || list.size() == 0) {
                return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            for (GoodsDirectionalConfigDto dto : list) {
                if (dto.getId() == null || dto.getId() == 0L) continue;
                GoodsDirectionalConfigEntity entity = this.dtoToEntity(dto);
                Long stockId = this.goodsDirectionalConfigService.find(dto.getId()).getStockId();
                if (dto.getStockChange() == null) continue;
                if (stockId == null) {
                    Long newStockId = this.getStockId(dto.getGoodsId(), dto.getStockChange());
                    entity.setStockId(newStockId);
                    this.goodsDirectionalConfigService.update(entity.getId(), newStockId, entity.getDayLimit(), entity.getMinPrice());
                    continue;
                }
                this.stockChange(stockId, dto.getStockChange());
                this.goodsDirectionalConfigService.update(entity.getId(), null, entity.getDayLimit(), entity.getMinPrice());
            }
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("update, error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> isExist(GoodsTypeEnum gtype, Long goodsId, Long appId) {
        try {
            if (gtype == null || goodsId == null || appId == null) {
                return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            GoodsDirectionalConfigEntity entity = this.goodsDirectionalConfigService.findByGoodsAndApp(gtype, goodsId, appId);
            boolean rs = entity != null;
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("isExist, error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<GoodsDirectionalConfigDto> findByGoodsAndApp(GoodsTypeEnum gtype, Long goodsId, Long appId) {
        try {
            if (gtype == null || goodsId == null || appId == null) {
                return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            GoodsDirectionalConfigEntity entity = this.goodsDirectionalConfigService.findByGoodsAndApp(gtype, goodsId, appId);
            GoodsDirectionalConfigDto rs = this.entityToDto(entity);
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("findByGoodsAndApp, error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    private GoodsDirectionalConfigDto entityToDto(GoodsDirectionalConfigEntity entity) {
        GoodsDirectionalConfigDto dto;
        if (entity == null) {
            dto = null;
        } else {
            dto = new GoodsDirectionalConfigDto();
            long stock = this.findStock(entity.getStockId());
            long totalStock = this.findTotalStock(entity.getStockId());
            dto.setId(entity.getId());
            dto.setAppId(entity.getAppId());
            dto.setGoodsId(entity.getGoodsId());
            dto.setGtype(GoodsTypeEnum.getGoodsTypeEnum((int)entity.getGoodsType()));
            dto.setDayLimit(entity.getDayLimit());
            dto.setMinPrice(entity.getMinPrice());
            dto.setStock(Long.valueOf(stock));
            dto.setSales(Long.valueOf(totalStock - stock));
        }
        return dto;
    }

    private GoodsDirectionalConfigEntity dtoToEntity(GoodsDirectionalConfigDto dto) {
        GoodsDirectionalConfigEntity entity;
        if (dto == null) {
            entity = null;
        } else {
            entity = new GoodsDirectionalConfigEntity();
            entity.setId(dto.getId());
            entity.setGoodsId(dto.getGoodsId());
            entity.setGoodsType(dto.getGtype().getGtype());
            entity.setAppId(dto.getAppId());
            entity.setDayLimit(dto.getDayLimit());
            entity.setMinPrice(dto.getMinPrice());
        }
        return entity;
    }

    private boolean stockChange(long stockId, long stockChange) {
        boolean rs = stockChange > 0L ? (Boolean)this.remoteStockBackendService.increaseItemStock(stockId, stockChange).getResult() : (stockChange < 0L ? (Boolean)this.remoteStockBackendService.decreaseItemStock(stockId, -stockChange).getResult() : true);
        return rs;
    }

    private Long getStockId(long gid, long firstStock) throws Exception {
        Long stockId = null;
        try {
            DubboResult dr = this.remoteStockBackendService.newStock(gid, firstStock);
            if (!dr.isSuccess()) {
                throw new Exception(dr.getMsg());
            }
            stockId = (Long)dr.getResult();
        }
        catch (Exception e) {
            log.error("remoteStockBackendService.newStock(" + gid + "," + firstStock + ")", (Throwable)e);
            throw e;
        }
        return stockId;
    }

    private long findStock(Long stockId) {
        long stock = 0L;
        if (stockId != null) {
            try {
                DubboResult dr = this.remoteStockBackendService.find(stockId.longValue());
                if (dr.isSuccess()) {
                    stock = (Long)dr.getResult();
                } else {
                    log.error("remoteStockBackendService.find(" + stockId + ") \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd," + dr.getMsg());
                }
            }
            catch (Exception e) {
                log.error("remoteStockBackendService.find(" + stockId + ") error,", (Throwable)e);
            }
        }
        return stock;
    }

    private long findTotalStock(Long stockId) {
        long totalstock = 0L;
        if (stockId != null) {
            try {
                DubboResult dr = this.remoteStockBackendService.findTotalStock(stockId.longValue());
                if (dr.isSuccess()) {
                    totalstock = (Long)dr.getResult();
                } else {
                    log.error("remoteStockBackendService.findTotalStock(" + stockId + ") \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd," + dr.getMsg());
                }
            }
            catch (Exception e) {
                log.error("remoteStockBackendService.findTotalStock(" + stockId + ") error,", (Throwable)e);
            }
        }
        return totalstock;
    }
}

