/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.pcg;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategoryDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFloorDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGSellerDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.pcg.PcgDetailDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemotePCGGoodsInfoService;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.bo.PCGFilterConfigBO;
import cn.com.duiba.goods.center.biz.bo.pcg.PCGUtilBO;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsContentEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsContentService;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.biz.service.GoodsTagsService;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.goods.center.biz.service.impl.GoodsDirectionalConfigServiceImpl;
import cn.com.duiba.goods.center.biz.util.PCGConvertUtil;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remotePCGGoodsInfoService")
public class RemotePCGGoodsInfoServiceImpl
implements RemotePCGGoodsInfoService {
    private static Logger LOGER = LoggerFactory.getLogger(RemotePCGGoodsInfoServiceImpl.class);
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    @Autowired
    private PCGFilterConfigService pCGFilterConfigService;
    @Autowired
    private PCGSellerGoodsService pCGSellerGoodsService;
    @Autowired
    private PCGCategoryGoodsService pCGCategoryGoodsService;
    @Autowired
    private PCGFilterConfigBO pCGFilterConfigBO;
    @Autowired
    private GoodsContentService goodsContentService;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    @Autowired
    private PCGUtilBO pcgUtilBO;
    @Autowired
    private GoodsTagsService goodsTagsService;

    public PCGDto find(long pcgId) {
        PlatformCouponGoodsEntity pcg = this.platformCouponGoodsService.find(pcgId);
        if (pcg == null) {
            return null;
        }
        PCGDto dto = PCGConvertUtil.convert(pcg);
        return dto;
    }

    public DubboResult<PcgDetailDto> findForDetail(long pcgId, long appId) {
        try {
            GoodsDirectionalConfigServiceImpl.DayLimitConfig config;
            PlatformCouponGoodsEntity pcg = this.platformCouponGoodsService.find(pcgId);
            if (pcg == null) {
                return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            if (this.goodsTagsService.containsAppTag(pcgId, appId)) {
                return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd(2)");
            }
            GoodsContentEntity content = this.goodsContentService.findByGoods(GoodsTypeEnum.PLATFORM, pcgId);
            long stock = this.pcgUtilBO.getStockInApp(pcgId, appId);
            GoodsBatchEntity using = this.goodsBatchService.getUsingBatch(GoodsTypeEnum.PLATFORM, pcgId);
            PcgDetailDto dto = new PcgDetailDto();
            dto.setPcgId(Long.valueOf(pcgId));
            dto.setDescription(content.getContent());
            dto.setImage(pcg.getDetailImage());
            dto.setStock(Long.valueOf(stock));
            dto.setSubtitle(pcg.getSubtitle());
            dto.setTitle(pcg.getTitle());
            dto.setLimitPerConsumer(pcg.getLimitPerConsumer());
            if (using != null) {
                dto.setValidEndDate(using.getEndDay());
                dto.setValidStartDate(using.getStartDay());
            }
            if ((config = this.goodsDirectionalConfigService.getDayLimit(GoodsTypeEnum.PLATFORM, pcgId, appId)) != null) {
                dto.setDayLimit(config.getDayLimit());
            }
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            LOGER.error("findForDetail error,pcgId=" + pcgId + ",appId=" + appId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public PCGDto findIncludeDeleted(long pcgId) {
        PlatformCouponGoodsEntity pcg = this.platformCouponGoodsService.findIncludeDeleted(pcgId);
        if (pcg == null) {
            return null;
        }
        PCGDto dto = PCGConvertUtil.convert(pcg);
        GoodsContentEntity goods = this.goodsContentService.findByGoods(GoodsTypeEnum.PLATFORM, pcgId);
        if (goods != null) {
            dto.setDetail(goods.getContent());
        }
        return dto;
    }

    public DubboResult<List<PCGCategoryDto>> findCategoryAll() {
        try {
            ArrayList PCGCategoryDtos = new ArrayList();
            List<PCGCategoryEntity> categorys = this.pCGCategoryGoodsService.findAll();
            ObjectUtil.convertList(categorys, PCGCategoryDtos, PCGCategoryDto.class);
            return DubboResult.successResult(PCGCategoryDtos);
        }
        catch (Exception e) {
            LOGER.error("findCategoryAll", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<PCGSellerDto>> findSellerAll() {
        try {
            ArrayList pCGSellerDtos = new ArrayList();
            List<PCGSellerEntity> sellers = this.pCGSellerGoodsService.findAll();
            ObjectUtil.convertList(sellers, pCGSellerDtos, PCGSellerDto.class);
            return DubboResult.successResult(pCGSellerDtos);
        }
        catch (Exception e) {
            LOGER.error("findSellerAll", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Page<PCGCategorySellerGoodsDto>> findCategoryGoods(long appId, long categoryId, Long consumerId, Long consumerCredits, Integer pageIndex, Integer pageSize) {
        try {
            Page<PCGCategorySellerGoodsDto> page = this.pCGFilterConfigBO.findCategoryGoods(appId, categoryId, consumerId, consumerCredits, pageIndex, pageSize);
            return DubboResult.successResult(page);
        }
        catch (Exception e) {
            LOGER.error("findCategoryGoods appId=" + appId + ",consumerId=" + consumerId + ",consumerCredits=" + consumerCredits + ",pageIndex=" + pageIndex + ",pageSize=" + pageSize, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Page<PCGCategorySellerGoodsDto>> findSellerGoods(long appId, long sellerId, Long consumerId, Long consumerCredits, Integer pageIndex, Integer pageSize) {
        try {
            Page<PCGCategorySellerGoodsDto> page = this.pCGFilterConfigBO.findSellerGoods(appId, sellerId, consumerId, consumerCredits, pageIndex, pageSize);
            return DubboResult.successResult(page);
        }
        catch (Exception e) {
            LOGER.error("findSellerGoods appId=" + appId + ",consumerId=" + consumerId + ",consumerCredits=" + consumerCredits + ",pageIndex=" + pageIndex + ",pageSize=" + pageSize, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<Long>> findPCGFilterTargetIds(Long appId, Integer type) {
        try {
            List<Long> list = this.pCGFilterConfigService.selectPCGFilterTargetIds(appId, type);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            LOGER.error("findPCGFilterTargetIds appId=" + appId + ",type=" + type, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<PCGCategorySellerGoodsDto> findSellerGoodsInfo(long appId, long gid, Long consumerId, Long consumerCredits) {
        try {
            PCGCategorySellerGoodsDto dto = this.pCGFilterConfigService.findSellerGoodsInfo(appId, gid, consumerId, consumerCredits);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            LOGER.error("findGoodsCouponInfo gid=" + gid, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    @Deprecated
    public DubboResult<List<Long>> findPcgIds4Floor(Long appId, Integer size) {
        try {
            List<PCGCategorySellerGoodsDto> categoryGoodsList = this.pCGFilterConfigService.selectPCGCategoryGoodsList(appId);
            List<PCGCategorySellerGoodsDto> sellerGoodsList = this.pCGFilterConfigService.selectPCGSellerGoodsList(appId);
            sellerGoodsList.removeAll(categoryGoodsList);
            sellerGoodsList.addAll(categoryGoodsList);
            Collections.sort(sellerGoodsList);
            sellerGoodsList.subList(0, size);
            ArrayList<Long> result = new ArrayList<Long>(categoryGoodsList.size());
            for (PCGCategorySellerGoodsDto it : categoryGoodsList) {
                result.add(it.getPcgId());
            }
            return DubboResult.successResult(result);
        }
        catch (Exception e) {
            LOGER.error("findPcgIds4Floor appId=" + appId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<PCGFloorDto>> findPcg4Floor(List<Long> pcgIds, Long appId, Long consumerId, Long appRate, Long consumerCredits) {
        try {
            List result = Collections.emptyList();
            return DubboResult.successResult(result);
        }
        catch (Exception e) {
            LOGER.error("findPcg4Floor pcgIds=" + pcgIds, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<PCGFloorDto>> findPcg4Floor(Long appId, Integer size) {
        try {
            List<PCGFloorDto> result = this.pCGFilterConfigBO.findPcgByAppId(appId, size);
            return DubboResult.successResult(result);
        }
        catch (Exception e) {
            LOGER.error("findPcg4Floor appId=" + appId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

