/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.impl.GoodsBatchServiceImpl;
import cn.com.duiba.goods.center.common.RedisKeyTool;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="goodsBatchRedisService")
public class GoodsBatchRedisService
extends GoodsBatchServiceImpl
implements GoodsBatchService {
    private static final Logger log = LoggerFactory.getLogger(GoodsBatchRedisService.class);
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private RedisBatchCache redisBatchCache = new RedisBatchCache();

    @Override
    public boolean getBatchLock(Long goodsBatchId, Long gid, GoodsTypeEnum gtype) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)this.redisBatchCache.getBatchGoodsLockKey(goodsBatchId, gid, gtype), (Object)"1");
    }

    @Override
    public void releaseBatchLock(Long goodsBatchId, Long gid, GoodsTypeEnum gtype) {
        this.redisTemplate.delete((Object)this.redisBatchCache.getBatchGoodsLockKey(goodsBatchId, gid, gtype));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GoodsBatchEntity> findNormalBatchs(GoodsTypeEnum gtype, long gid) {
        try {
            DBTimeProfile.enter((String)"GoodsBatchRedisService.findNormalBatchs");
            List<GoodsBatchEntity> batchs = this.findNotDeletedBatchs(gtype, gid);
            ArrayList<GoodsBatchEntity> ret = new ArrayList<GoodsBatchEntity>();
            Date today = new DateTime().withTimeAtStartOfDay().toDate();
            for (GoodsBatchEntity e : batchs) {
                if (e.getEndDay().before(today)) continue;
                ret.add(e);
            }
            ArrayList<GoodsBatchEntity> arrayList = ret;
            return arrayList;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GoodsBatchEntity> findNotDeletedBatchs(GoodsTypeEnum gtype, long gid) {
        try {
            DBTimeProfile.enter((String)"GoodsBatchRedisService.findNotDeletedBatchs");
            List<GoodsBatchEntity> batchs = this.redisBatchCache.getBatchsCache(gtype, gid);
            if (batchs == null) {
                batchs = super.findNotDeletedBatchs(gtype, gid);
                this.redisBatchCache.setBatchsCache(gtype, gid, batchs);
            }
            List<GoodsBatchEntity> list = batchs;
            return list;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public GoodsBatchEntity getUsingBatch(GoodsTypeEnum gtype, long gid) {
        List<GoodsBatchEntity> normals = this.findNormalBatchs(gtype, gid);
        for (GoodsBatchEntity e : normals) {
            if (e.getStatus() != 2) continue;
            return e;
        }
        return null;
    }

    @Override
    public Long createNormalBatch(GoodsTypeEnum gtype, long gid, Date start, Date end, Long stockId) {
        Long ret = super.createNormalBatch(gtype, gid, start, end, stockId);
        this.redisBatchCache.clearBatchsCache(gtype, gid);
        return ret;
    }

    @Override
    public Long createLinkBatch(GoodsTypeEnum gtype, long gid, Date start, Date end, Long stockId) {
        Long ret = super.createLinkBatch(gtype, gid, start, end, stockId);
        this.redisBatchCache.clearBatchsCache(gtype, gid);
        return ret;
    }

    @Override
    public Long createRepeatBatch(GoodsTypeEnum gtype, long gid, Date start, Date end, Long stockId) {
        Long ret = super.createRepeatBatch(gtype, gid, start, end, stockId);
        this.redisBatchCache.clearBatchsCache(gtype, gid);
        return ret;
    }

    @Override
    public Boolean deleteBatch(GoodsTypeEnum gtype, long gid, Long batchId) {
        Boolean ret = super.deleteBatch(gtype, gid, batchId);
        this.redisBatchCache.clearBatchsCache(gtype, gid);
        return ret;
    }

    @Override
    public GoodsBatchEntity find(Long goodsBatchId) {
        return super.find(goodsBatchId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getSumBatchStock(GoodsTypeEnum gtype, long gid) {
        try {
            DBTimeProfile.enter((String)"GoodsBatchRedisService.getSumBatchStock");
            Long l = super.getSumBatchStock(gtype, gid);
            return l;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public Long getTotalAllBatchStock(GoodsTypeEnum gtype, long gid) {
        return super.getTotalAllBatchStock(gtype, gid);
    }

    @Override
    public void markBatchStatusNotUsed(long batchId) {
        super.markBatchStatusNotUsed(batchId);
        GoodsBatchEntity batch = super.find(batchId);
        this.redisBatchCache.clearBatchsCache(GoodsTypeEnum.getGoodsTypeEnum((int)batch.getGtype()), batch.getGid());
    }

    @Override
    public void markBatchStatusUsed(long batchId) {
        super.markBatchStatusUsed(batchId);
        GoodsBatchEntity batch = super.find(batchId);
        this.redisBatchCache.clearBatchsCache(GoodsTypeEnum.getGoodsTypeEnum((int)batch.getGtype()), batch.getGid());
    }

    @Override
    public void markBatchStatusUsing(long batchId) {
        super.markBatchStatusUsing(batchId);
        GoodsBatchEntity batch = super.find(batchId);
        this.redisBatchCache.clearBatchsCache(GoodsTypeEnum.getGoodsTypeEnum((int)batch.getGtype()), batch.getGid());
    }

    @Override
    public Boolean updateValidDate(GoodsTypeEnum gtype, long gid, long batchId, Date startDay, Date endDay) {
        Boolean result = super.updateValidDate(gtype, gid, batchId, startDay, endDay);
        this.redisBatchCache.clearBatchsCache(gtype, gid);
        return result;
    }

    public class RedisBatchCache {
        public List<GoodsBatchEntity> getBatchsCache(GoodsTypeEnum gtype, long gid) {
            String string = (String)GoodsBatchRedisService.this.redisTemplate.opsForValue().get((Object)this.getRedisBatchsKey(gtype, gid));
            if (string == null) {
                return null;
            }
            return JSONObject.parseArray((String)string, GoodsBatchEntity.class);
        }

        public void clearBatchsCache(GoodsTypeEnum gtype, long gid) {
            try {
                GoodsBatchRedisService.this.redisTemplate.delete((Object)this.getRedisBatchsKey(gtype, gid));
            }
            catch (Exception e) {
                log.error("RedisBatchCache.clearBatchsCache gtype=" + gtype.getGtype() + ",gid=" + gid, (Throwable)e);
            }
        }

        public void setBatchsCache(GoodsTypeEnum gtype, long gid, List<GoodsBatchEntity> batchs) {
            String string = JSONObject.toJSONString(batchs);
            GoodsBatchRedisService.this.redisTemplate.opsForValue().set((Object)this.getRedisBatchsKey(gtype, gid), (Object)string);
            GoodsBatchRedisService.this.redisTemplate.expire((Object)this.getRedisBatchsKey(gtype, gid), 1L, TimeUnit.HOURS);
        }

        private String getRedisBatchsKey(GoodsTypeEnum gtype, long gid) {
            return RedisKeyTool.getRedisKey(this.getClass(), (String)"", (String)(gtype.getGtype() + "-" + gid));
        }

        public String getBatchGoodsLockKey(Long goodsBatchId, Long gid, GoodsTypeEnum gtype) {
            return RedisKeyTool.getRedisKey(this.getClass(), (String)"batch_lock", (String)(goodsBatchId + "-" + gid));
        }
    }
}

