/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.util;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.AppendObjectRequest;
import com.aliyun.oss.model.AppendObjectResult;
import com.aliyun.oss.model.ObjectMetadata;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AppendUploadUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AppendUploadUtil.class);
    @Value(value="${goods.oss.endPoint}")
    private String endpoint;
    @Value(value="${goods.oss.accessId}")
    private String accessKeyId;
    @Value(value="${goods.oss.accessKey}")
    private String accessKeySecret;
    @Value(value="${goods.oss.bucketName}")
    private String bucketName;
    private String key;

    public Long upload(String content, Long position) throws Exception {
        OSSClient client = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
        AppendObjectResult appendObjectResult = null;
        try {
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType("application/octet-stream");
            ByteArrayInputStream instream = new ByteArrayInputStream(content.getBytes());
            appendObjectResult = client.appendObject(new AppendObjectRequest(this.bucketName, this.key, (InputStream)instream, meta).withPosition(position));
        }
        catch (Exception e) {
            LOG.error("oss\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e);
            throw e;
        }
        finally {
            client.shutdown();
        }
        return appendObjectResult.getNextPosition();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

