package cn.com.duiba.goods.center.biz.bo.impl;

import java.text.SimpleDateFormat;
import java.util.*;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.constant.PlatformCouponGoodsConstant;
import cn.com.duiba.goods.center.api.remoteservice.dto.*;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.bo.GoodsBatchCouponBackendBO;
import cn.com.duiba.goods.center.biz.bo.PCGFilterConfigBO;
import cn.com.duiba.goods.center.biz.entity.*;
import cn.com.duiba.goods.center.biz.service.*;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
@Service
public class PCGFilterConfigBOImpl implements PCGFilterConfigBO{

    private static Logger LOGGER = LoggerFactory.getLogger(PCGFilterConfigBOImpl.class);

    public static class PCGIdAndPayLoad{
        public PCGIdAndPayLoad(){
            
        }
        public PCGIdAndPayLoad(Long pcgId,Integer payLoad){
            this.pagId = pcgId;
            this.payLoad = payLoad;
        }
        private Long pagId;
        private Integer payLoad;
        public Long getPagId() {
            return pagId;
        }
        public Integer getPayLoad() {
            return payLoad;
        }
        
        
    }

    @Autowired
    private PCGFilterConfigService        pCGFilterConfigService;
    @Autowired
    private PCGCategoryGoodsService       pCGCategoryGoodsService;
    @Autowired
    private PCGSellerGoodsService         pCGSellerGoodsService;
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    @Autowired
    private PlatformCouponGoodsService    platformCouponGoodsService;
    @Autowired
    protected GoodsBatchService           goodsBatchService;
    @Autowired
    protected RemoteAppService            remoteAppService;
    @Autowired
    protected RemoteStockBackendService   remoteStockBackendService;
    @Autowired
    protected GoodsLimitRecordService     goodsLimitRecordService;
    @Autowired
    protected GoodsBatchCouponBackendBO   goodsBatchCouponBackendBO;
    private SimpleDateFormat              sdf  = new SimpleDateFormat("yyyy.MM.dd");
    private SimpleDateFormat              sdf2 = new SimpleDateFormat("yyyyMMdd");

    public List<Long> filterGoods(List<Long> pcgIds, Long appId) {
        List<Long> filterGoodsIds = pCGFilterConfigService.selectPCGFilterTargetIds(appId,
                                                                                    PlatformCouponGoodsConstant.PcgFilterConfigGoodsType);
        if (!filterGoodsIds.isEmpty()) {
            Iterator<Long> ps = pcgIds.iterator();
            while (ps.hasNext()) {
                Long pcgId = ps.next();
                for (Long filterGoodsId : filterGoodsIds) {
                    // 当前商品被屏蔽，清除
                    if ((pcgId - filterGoodsId) == 0) {
                        ps.remove();
                    }
                }
            }
        }
        return pcgIds;
    }
    
    @Override
    public Page<PCGCategorySellerGoodsDto> findCategoryGoods(long appId, long categoryId, Long consumerId,
                                                             Long consumerCredits, Integer pageIndex, Integer pageSize) {
        List<Long> pcgIds = new ArrayList<Long>();
        // 1.查询该类目下的所有商品
        List<PCGCategoryGoodsEntity> pCGCategoryGoodsEntity = pCGCategoryGoodsService.findAllGoodsByCategory(categoryId);

        List<PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<PCGIdAndPayLoad>();
        for (PCGCategoryGoodsEntity cateGoods : pCGCategoryGoodsEntity) {
            pcgIds.add(cateGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGIdAndPayLoad(cateGoods.getPcgId(), cateGoods.getPayload()));
        }
        pCGFilterConfigService.goodsTagsIdFilter(pcgIds, appId);
        // 2.商品进行单品黑名单过滤
        pcgIds = checkBlack(pcgIds, appId);
        // 4.放入商品信息
        Page<PCGCategorySellerGoodsDto> page = new Page<PCGCategorySellerGoodsDto>(pageSize, pageIndex);
        if (pcgIds !=null && !pcgIds.isEmpty()) {
            page = findGoods(appId, pcgIds, consumerId, consumerCredits, pCGIdAndPayLoads, pageIndex, pageSize);
        }
        return page;
    }

    /**
     * set排序号
     * 
     * @param pCGCategoryGoodsEntity
     * @param p
     * @return
     */
    public static Integer setPayLoad(List<PCGIdAndPayLoad> ppl, Long pcgId) {
        for (PCGIdAndPayLoad p : ppl) {
            if (p.getPagId().longValue() == pcgId.longValue()) {
                return p.getPayLoad();
            }
        }
        return 0;
    }

    /**
     * 查询商品信息
     * 
     * @param appId
     * @param pcgIds
     * @param consumerId
     * @param consumerCredits
     * @return
     */
    public Page<PCGCategorySellerGoodsDto> findGoods(Long appId, List<Long> pcgIds, Long consumerId,
                                                     Long consumerCredits, List<PCGIdAndPayLoad> pCGIdAndPayLoads,
                                                     Integer pageIndex, Integer pageSize) {
        List<PCGCategorySellerGoodsDto> goodsList = new ArrayList<PCGCategorySellerGoodsDto>();
        /*** 查询开启预分配商品列表 */
        Map<String, GoodsDirectionalConfigEntity> directionals = goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM,
                                                                                                              pcgIds);
        /*** 查询数据库商品列表 */
        Map<Long, PlatformCouponGoodsEntity> pcgs = platformCouponGoodsService.findByIds(pcgIds);
        for (Long pcgIdKey : pcgs.keySet()) {
            GoodsDirectionalConfigEntity gdce1 = null;
            GoodsDirectionalConfigEntity gdce2 = null;
            PlatformCouponGoodsEntity pce = pcgs.get(pcgIdKey);
            // 券是未启用状态,删除状态。返回
            if (PlatformCouponGoodsConstant.PcgStatusOn != pce.getPcgStatus().intValue() || pce.getDeleted()) {
                continue;
            }
            // 开启预分配
            if (isOpen(PlatformCouponGoodsConstant.PcgDirectionalSwitches, pce.getSwitches().intValue())) {
                if (!directionals.isEmpty()) {
                    // 查询是否存在清单
                    gdce1 = directionals.get(appId + "-" + pcgIdKey);
                    // 查询是否存在共享库，共享库appId是0
                    gdce2 = directionals.get(0 + "-" + pcgIdKey);
                    // 如果券开启了库存预分配，且当前应用和共享库均不在预分配清单中则不展示；
                    if (gdce1 == null && gdce2 == null) {
                        continue;
                    }

                }
            }
            PCGCategorySellerGoodsDto psgd = new PCGCategorySellerGoodsDto();
            ObjectUtil.convert(pce, psgd);
            GoodsDirectionalConfigDto gc = new GoodsDirectionalConfigDto();
            // 设置库存
            if (gdce2 != null) {
                ObjectUtil.convert(gdce2, gc);
                if (gdce2.getStockId() == null) {
                    gc.setStock(0L);
                } else {
                    DubboResult<Long> result = remoteStockBackendService.find(gdce2.getStockId());
                    if (result != null && result.isSuccess()) {
                        if (result.getResult() != null ) {
                            gc.setStock(result.getResult());
                        }
                    }
                }
            }
            if (gdce1 != null) {
                gc = new GoodsDirectionalConfigDto();
                ObjectUtil.convert(gdce1, gc);
                if (gdce1.getStockId() == null) {
                    gc.setStock(0L);
                } else {
                    // 当前商品预分配的库存
                    DubboResult<Long> result = remoteStockBackendService.find(gdce1.getStockId());
                    if (result != null && result.isSuccess()) {
                        if (result.getResult() != null ) {
                            gc.setStock(result.getResult());
                        }
                    }
                }
            }
            // 设置开奖预分配对象，积分展示需要调用
            psgd.setGoodsDirectionalConfigDto(gc);
            // 设置排序值
            psgd.setPayLoad(setPayLoad(pCGIdAndPayLoads, psgd.getPcgId()));
            long pcgStock = goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, pce.getPcgId());
            psgd.setStock(pcgStock);
            goodsList.add(psgd);
        }
        return page(pageIndex, pageSize, goodsList);
    }

    @Override
    public Page<PCGCategorySellerGoodsDto> findSellerGoods(long appId, long sellerId, Long consumerId,
                                                           Long consumerCredits, Integer pageIndex, Integer pageSize) {
        List<Long> pcgIds = new ArrayList<Long>();
        List<PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<PCGIdAndPayLoad>();
        // 1.查询该类目下的所有商品
        List<PCGSellerGoodsEntity> pCGSellerGoodsEntity = pCGSellerGoodsService.findAllGoodsBySeller(sellerId);
        for (PCGSellerGoodsEntity cateGoods : pCGSellerGoodsEntity) {
            pcgIds.add(cateGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGIdAndPayLoad(cateGoods.getPcgId(), cateGoods.getPayload()));
        }
        pCGFilterConfigService.goodsTagsIdFilter(pcgIds, appId);
        // 2.商品进行单品黑名单过滤
        pcgIds = checkBlack(pcgIds, appId);
        Page<PCGCategorySellerGoodsDto> page = new Page<PCGCategorySellerGoodsDto>(pageSize, pageIndex);
        // 3.放入商品信息
        if (!pcgIds.isEmpty()) {
            page = findGoods(appId, pcgIds, consumerId, consumerCredits, pCGIdAndPayLoads, pageIndex, pageSize);
        }
        return page;
    }
    
    /**
     * 批量验证商品黑名单
     * @param pcgIds
     * @param appId
     * @return
     */
    @Override
    public List<Long>  checkBlack(List<Long> pcgIds,Long appId){
    	List<PCGCategoryEntity> cates=pCGFilterConfigService.findCategoryFilterList(appId);
    	Set<Long> catSet=new HashSet<>();
    	for(PCGCategoryEntity c:cates){
    		catSet.add(c.getId());
    	}
    	
    	List<PCGSellerEntity> sellers=pCGFilterConfigService.findSellerFilterList(appId);
    	Set<Long> sellerSet=new HashSet<>();
    	for(PCGSellerEntity e:sellers){
    		sellerSet.add(e.getId());
    	}
    	
    	Map<Long,List<PCGFilterConfigDto>> belongs= pCGFilterConfigService.findFilterCounponBelongs(catSet,sellerSet);
    	
    	List<PlatformCouponGoodsEntity> goodss=pCGFilterConfigService.findGoodsFilterList(appId);
    	boolean flag = true;
        Iterator<Long> ps = pcgIds.iterator();
        while (ps.hasNext()) {
        	flag = true;//标识商品是否已经加入黑名单
            long pcgId = ps.next();
            for (PlatformCouponGoodsEntity goods : goodss) {
                // 当前商品被屏蔽，清除
                if ((pcgId - goods.getPcgId()) == 0) {
                    ps.remove();
                    flag = false;
                    break;
                }
            }
            if(belongs !=null &&  !belongs.isEmpty()){
            	List<PCGFilterConfigDto> pcs =  belongs.get(pcgId);
            	if(flag && pcs !=null && !pcs.isEmpty()){
            		for(PCGFilterConfigDto f:belongs.get(pcgId)){
            			if(f.getType()==PlatformCouponGoodsConstant.PcgFilterConfigCategoryType){
            				if(catSet.contains(f.getTargetId())){
            					//商品所属类目在黑名单中
            					ps.remove();
            					break;
            				}
            			}else if(f.getType()==PlatformCouponGoodsConstant.PcgFilterConfigSellerType){
            				if(sellerSet.contains(f.getTargetId())){
            					//商品在所属品牌的黑名单中
            					ps.remove();
            					break;
            				}
            			}
            		}
            	}
            }
        }
        return pcgIds;
    }



    public static boolean isOpen(int bit, int switches) {
        int v = 1 << bit;
        int ret = switches & v;
        return ret != 0;
    }

    public <T extends Comparable<? super T>> Page<T> page(Integer pageIndex, Integer pageSize, List<T> t) {
        Page<T> page = new Page<T>(pageSize, pageIndex);
        List<T> newList = new ArrayList<T>();
        page.setList(newList);
        if (t.isEmpty()) {
            return page;
        }
        Collections.sort(t);
        int total = t.size();
        int index = 0;// 循环索引开始
        // 大于两页
        if (pageIndex > 1) {
            index = (pageIndex - 1) * pageSize;
        }
        int totalPages = total % pageSize == 0 ? total / pageSize : (total / pageSize + 1);
        // 索引页必须小于总的页数
        if (pageIndex <= totalPages) {
            if (pageIndex == 1) {
                pageIndex = 0;
            }
            for (int i = index; i < total; i++) {
                // 只取20条，满足跳出
                if (pageSize * (pageIndex + 1) == i) {
                    break;
                }
                newList.add(t.get(i));
            }
        }
        page.setList(newList);
        page.setTotalPages(totalPages);
        page.setPageSize(pageSize);
        page.setCurrent(pageIndex);
        return page;
    }


    @Override
    public List<PCGFloorDto> findPcgByAppId(Long appId, Integer size) {
        List<PCGCategorySellerGoodsDto> categoryGoodsList = pCGFilterConfigService.selectPCGCategoryGoodsList(appId);
        List<PCGCategorySellerGoodsDto> sellerGoodsList = pCGFilterConfigService.selectPCGSellerGoodsList(appId);
        sellerGoodsList.removeAll(categoryGoodsList);
        sellerGoodsList.addAll(categoryGoodsList);
        Collections.sort(sellerGoodsList);

        List<Long> pcgIds = new ArrayList<>();
        for (PCGCategorySellerGoodsDto it : sellerGoodsList) {
            if(pcgIds.size()<size) pcgIds.add(it.getPcgId());
            else break;
        }
        sellerGoodsList = sellerGoodsList.subList(0,pcgIds.size());

        Map<String, GoodsDirectionalConfigEntity> directionals = goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM, pcgIds);
        Map<Long, PlatformCouponGoodsEntity> pcgs = platformCouponGoodsService.findByIds(pcgIds);

        List<PCGFloorDto> goodsList = new ArrayList<PCGFloorDto>();

        for (PCGCategorySellerGoodsDto it : sellerGoodsList) {
            PlatformCouponGoodsEntity pce = pcgs.get(it.getPcgId());
            if (!canShow(directionals, pce, appId)) {
                continue;
            }
            PCGFloorDto psgd = new PCGFloorDto();
            ObjectUtil.convert(pce, psgd);
            psgd.setMinPrice(getMinPrice(directionals, pce, appId));
            psgd.setPayLoad(it.getPayLoad());
            setGoodsBatch(psgd, it.getPcgId());
            goodsList.add(psgd);
        }
        
        return goodsList;
    }


    @Deprecated
    public List<PCGFloorDto> findPcgByIds(final List<Long> pcgIds, Long appId, Long consumerId, Long appRate, Long consumerCredits) {
        List<PCGFloorDto> goodsList = new ArrayList<PCGFloorDto>();
        /*** 查询开启预分配商品列表 */
        Map<String, GoodsDirectionalConfigEntity> directionals = goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM, pcgIds);
//        /*** 查询商品用户兑换次数 **/
//        List<GoodsLimitRecordEntity> list = goodsLimitRecordService.findCounts(GoodsTypeEnum.PLATFORM.getGtype(), pcgIds, consumerId);
//        Map<Long, Integer> exchangeCountMap = new HashMap<Long, Integer>();
//        for (GoodsLimitRecordEntity glre : list) {
//            exchangeCountMap.put(glre.getGid(), glre.getCount());
//        }
        /*** 查询数据库商品列表 */
        Map<Long, PlatformCouponGoodsEntity> pcgs = platformCouponGoodsService.findByIds(pcgIds);
        for (Long it : pcgs.keySet()) {
            PlatformCouponGoodsEntity pce = pcgs.get(it);
            if (!canShow(directionals, pce, appId)) {
                continue;
            }
            PCGFloorDto psgd = new PCGFloorDto();
            ObjectUtil.convert(pce, psgd);
            psgd.setStock(getStock(directionals, pce, appId));
            psgd.setMinPrice(getMinPrice(directionals, pce, appId));
            psgd.setPayLoad(0);
//            psgd.setExchangeType(getExchangeType(psgd, directionals, pce, exchangeCountMap, appId, appRate, consumerCredits));
            setGoodsBatch(psgd, it);
            goodsList.add(psgd);
        }
        Collections.sort(goodsList, new Comparator<PCGFloorDto>() {
            @Override
            public int compare(PCGFloorDto o1, PCGFloorDto o2) {
                if (pcgIds.indexOf(o1.getPcgId()) > pcgIds.indexOf(o2.getPcgId())) {
                    return 1;
                } else if (pcgIds.indexOf(o1.getPcgId()) < pcgIds.indexOf(o2.getPcgId())) {
                    return -1;
                } else {
                    return 0;
                }
            }
        });
        return goodsList;
    }

    /**
     * 填充开始结束时间
     * @param psgd
     * @param pcgId
     */
    private void setGoodsBatch(PCGFloorDto psgd, Long pcgId) {
        List<GoodsBatchDto> goodsBatchs = goodsBatchCouponBackendBO.findBatchs(GoodsTypeEnum.PLATFORM, pcgId);
        String currentTime = sdf2.format(new Date());
        for (GoodsBatchDto goodsBatch : goodsBatchs) {
            //当前批次有效，3：已使用完，4：已经删除，当前批次发放的券库存大于0 且 必须是有效日期
            if (goodsBatch.getStatus() != null && goodsBatch.getStatus() != 3 && goodsBatch.getStatus() != 4 &&
                    goodsBatch.getStock() > 0 && Integer.parseInt(sdf2.format(goodsBatch.getEndDay())) >= Integer.parseInt(currentTime)) {
                psgd.setStartDate(sdf.format(goodsBatch.getStartDay()));
                psgd.setEndDate(sdf.format(goodsBatch.getEndDay()));
                //设置1分钟缓存
                break;
            }
        }
        //如果全部批次都已发放完则展示最后添加的那个券码批次的有效期
        if (!goodsBatchs.isEmpty() && StringUtils.isBlank(psgd.getEndDate())) {
            psgd.setStartDate(sdf.format(goodsBatchs.get(goodsBatchs.size() - 1).getStartDay()));
            psgd.setEndDate(sdf.format(goodsBatchs.get(goodsBatchs.size() - 1).getEndDay()));
            //设置1分钟缓存
        }
    }

    /**
     * 获取兑换按钮状态
     * @param psgd
     * @param directionals
     * @param entity
     * @param exchangeCountMap
     * @param appId
     * @param appRate
     * @param consumerCredits
     * @return
     */
    private int getExchangeType(PCGFloorDto psgd, Map<String, GoodsDirectionalConfigEntity> directionals, PlatformCouponGoodsEntity entity, Map<Long, Integer> exchangeCountMap, Long appId, Long appRate, Long consumerCredits) {
        Integer consumerExchangeCount = exchangeCountMap.get(entity.getPcgId());
        if (consumerExchangeCount == null) {
            consumerExchangeCount = 0;
        }
        // 兑换积分价格
        Long credits = getCredits(psgd.getMinPrice(), appRate);
        if (credits == null) {
            LOGGER.error("积分计算异常,最小价格为 null");
            return PlatformCouponGoodsConstant.PCGGoodsExchangeType3;
        }
        GoodsDirectionalConfigEntity directionalConfig = getGoodsDirectionalConfig(directionals, entity, appId);
        Integer dayLimit = null;
        if (directionalConfig != null) {
            dayLimit = directionalConfig.getDayLimit();
        }
        int result = 0;
        // 已兑换,兑换限制不为空,兑换限制-已兑换次数(未超出限制)
        if (entity.getLimitPerConsumer() != null && (entity.getLimitPerConsumer() - consumerExchangeCount) <= 0) {
            result = PlatformCouponGoodsConstant.PCGGoodsExchangeType1;
            psgd.setPayLoad(psgd.getPayLoad() == null ? 0 : psgd.getPayLoad() + 400);
        // 积分不足, 用户积分 < 兑换价格
        } else if (consumerCredits <= credits) {
            result = PlatformCouponGoodsConstant.PCGGoodsExchangeType2;
        // 已兑完, 商品本身库存 = 0 || 开启预分配,预分配为0 || 预分配限额
        } else if (psgd.getStock() == 0 || !checkDayLimit(dayLimit, consumerExchangeCount)) {
            result = PlatformCouponGoodsConstant.PCGGoodsExchangeType3;
            psgd.setPayLoad(psgd.getPayLoad() == null ? 0 : psgd.getPayLoad() + 300);
        // 兑换
        } else {
            result = PlatformCouponGoodsConstant.PCGGoodsExchangeType4;
        }
        return result;
    }

    /**
     * 验证预分配限额
     * true 表示不限制
     * false 表示限制
     * @param dayLimit
     * @param consumerExchangeCount
     * @return
     */
    private boolean checkDayLimit(Integer dayLimit, Integer consumerExchangeCount) {
        if (dayLimit != null && (dayLimit - consumerExchangeCount) <= 0) {
            return false;
        }
        return true;
    }

    /**
     * 是否可以展示
     * @param directionals
     * @param entity
     * @param appId
     * @return
     */
    private boolean canShow(Map<String, GoodsDirectionalConfigEntity> directionals, PlatformCouponGoodsEntity entity, Long appId) {
        GoodsDirectionalConfigEntity gdce1 = null;
        GoodsDirectionalConfigEntity gdce2 = null;
        // 券是未启用状态,删除状态。返回
        if (PlatformCouponGoodsConstant.PcgStatusOn != entity.getPcgStatus() || entity.getDeleted()) {
            return false;
        }
        // 没有开启预分配
        if (!isOpen(PlatformCouponGoodsConstant.PcgDirectionalSwitches, entity.getSwitches().intValue())) {
            return true;
        }
        GoodsDirectionalConfigEntity directionalConfig = getGoodsDirectionalConfig(directionals, entity, appId);
        return directionalConfig != null;
    }

    /**
     * 获取预分配关系
     * @param directionals
     * @param entity
     * @param appId
     * @return
     */
    private GoodsDirectionalConfigEntity getGoodsDirectionalConfig(Map<String, GoodsDirectionalConfigEntity> directionals, PlatformCouponGoodsEntity entity, Long appId) {
        // 开启预分配
        if (!isOpen(PlatformCouponGoodsConstant.PcgDirectionalSwitches, entity.getSwitches().intValue())) {
            return null;
        }
        if (directionals.isEmpty()) {
            return null;
        }
        GoodsDirectionalConfigEntity gdce1 = null;
        GoodsDirectionalConfigEntity gdce2 = null;
        // 查询是否存在清单
        gdce1 = directionals.get(appId + "-" + entity.getPcgId());
        // 查询是否存在共享库，共享库appId是0
        gdce2 = directionals.get(0 + "-" + entity.getPcgId());
        // 如果券开启了库存预分配，且当前应用和共享库均不在预分配清单中则不展示；
        if (gdce1 == null && gdce2 == null) {
            return null;
        }
        if (gdce1 != null) {
            return gdce1;
        } else {
            return gdce2;
        }
    }

    /**
     * 计算积分
     * @param duibaPrice
     * @param creditsRate
     * @return
     */
    private Long getCredits(Integer duibaPrice, Long creditsRate) {
        if (duibaPrice == null || creditsRate == null) {
            return null;
        }
        long credits = (long) Math.ceil(duibaPrice * creditsRate / 100.0);
        if (credits < 1L) {
            credits = 1L;
        }
        return credits;
    }

    /**
     * 计算最小积分
     * @param directionals
     * @param entity
     * @param appId
     * @return
     */
    private Integer getMinPrice(Map<String, GoodsDirectionalConfigEntity> directionals, PlatformCouponGoodsEntity entity, Long appId) {
        if (!isOpen(PlatformCouponGoodsConstant.PcgDirectionalSwitches, entity.getSwitches().intValue())) {
            return entity.getMinPrice();
        }
        GoodsDirectionalConfigEntity directionalConfig = getGoodsDirectionalConfig(directionals, entity, appId);
        if (directionalConfig == null) {
            return entity.getMinPrice();
        }
        return directionalConfig.getMinPrice() != null ? directionalConfig.getMinPrice() : entity.getMinPrice();
    }

    /**
     * 获取库存, 库存实际值和预分配的值取较小值
     * @param directionals
     * @param entity
     * @param appId
     * @return
     */
    private Long getStock(Map<String, GoodsDirectionalConfigEntity> directionals, PlatformCouponGoodsEntity entity, Long appId) {
        // 查询商品本身库存
        long pcgStock = goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, entity.getPcgId());
        if (pcgStock == 0) {
            return 0L;
        }
        if (!isOpen(PlatformCouponGoodsConstant.PcgDirectionalSwitches, entity.getSwitches().intValue())) {
            return pcgStock;
        }
        // 开启预分配
        long preStock = 0;
        GoodsDirectionalConfigEntity directionalConfig = getGoodsDirectionalConfig(directionals, entity, appId);
        if (directionalConfig == null) {
            return 0L;
        }
        DubboResult<Long> result = remoteStockBackendService.find(directionalConfig.getStockId());
        if (result != null && result.isSuccess()) {
            if (result.getResult() != null) {
                preStock = result.getResult();
            }
        }
        return Math.min(pcgStock, preStock);

    }
}
