/**
 * Project Name:goods-center-biz
 * File Name:GoodsBatchImportLogDaoImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.dao.impl
 * Date:2016年5月31日上午11:02:29
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao.impl;

import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseDao;
import cn.com.duiba.goods.center.biz.dao.GoodsBatchImportLogDao;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchImportLogEntity;

/**
 * ClassName:GoodsBatchImportLogDaoImpl <br/>
 * Date:     2016年5月31日 上午11:02:29 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository("goodsBatchImportLogDao")
public class GoodsBatchImportLogDaoImpl extends BaseDao implements  GoodsBatchImportLogDao{

    @Override
    public Long insert(GoodsBatchImportLogEntity e) {
        getSqlSession().insert(getStamentNameSpace("insert"),e);
        return e.getId();
    }

    @Override
    public GoodsBatchImportLogEntity select(Long id) {
        return getSqlSession().selectOne(getStamentNameSpace("select"),id);
    }
    
    @Override
    public int updateSuccessAndFail(Long id, int successCount, int failCount) {
        Map<String, Object> params=getBlankParams();
        params.put("id", id);
        params.put("successCount", successCount);
        params.put("failCount", failCount);
        return getSqlSession().update(getStamentNameSpace("updateSuccessAndFail"), params);
    }

}

