package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.ElasticGiftsItemShowDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteItemGoodsService;
import cn.com.duiba.goods.center.biz.service.item.ItemGoodsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by gyf .
 * 16/10/17 .
 */
@Service("remoteItemGoodsService")
public class RemoteItemGoodsServiceImpl implements RemoteItemGoodsService {

    private static Logger LOGGER = LoggerFactory.getLogger(RemotePlatformCouponGoodsBackendServiceImpl.class);

    @Autowired
    private ItemGoodsService itemGoodsService;

    @Override
    public DubboResult<Boolean> checkElasticTakeOrder(Long itemId, Long appId, Long consumerId) {
        try {
            itemGoodsService.checkElasticTakeOrder(itemId, appId, consumerId);
            return DubboResult.successResult(true);
        } catch (Exception e) {
            LOGGER.error("checkElasticTakeOrder ", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<ElasticGiftsItemShowDto>> getItemsByElItemIds4Mobile(List<Long> itemIds, Long appId, Long consumerId) {
        try {
            List<ElasticGiftsItemShowDto> result = itemGoodsService.getItemsByElItemIds4Mobile(itemIds, appId, consumerId);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("getItemsByElItemIds ", e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
