package cn.com.duiba.goods.center.biz.bo.item.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.ItemKeyUtils;
import cn.com.duiba.goods.center.biz.bo.item.ItemKeyBo;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.HomeAppItemService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;

/**
 * Created by liuyao on 2016/11/16.
 */
@Service
public class ItemKeyBoImpl implements ItemKeyBo {
    @Autowired
    private HomeAppItemService homeAppItemService;
    @Autowired
    private AppItemService appItemService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private GoodsBatchService goodsBatchService;

    @Override
    public List<ItemKeyDto> findHomeItemKeyCacheList(Long appId) {
        return findHomeItemKeyList(appId);
    }

    @Override
    public List<ItemKeyDto> findHomeItemKeyList(Long appId) {
        List<AppItemDto> appItems = homeAppItemService.findhomeAppItemNeed(appId);
        return transformAppItemList(appItems);
    }

    /**
     * 设置库存
     * @param itemKeyDtos
     */
    private void batchFindGoodsCouponStock(List<ItemKeyDto> itemKeyDtos) {
        List<Long> appItemIds = new ArrayList<>();
        List<Long> itemIds = new ArrayList<>();
        for (ItemKeyDto itemKey : itemKeyDtos) {
            if (ItemKeyUtils.isGoodsCoupon(itemKey)) {
                if (itemKey.isSelfAppItemMode()) {
                    appItemIds.add(itemKey.getAppItem().getId());
                } else if (itemKey.isDuibaAppItemMode() || itemKey.isItemMode()) {
                    itemIds.add(itemKey.getItem().getId());
                }
            }
        }
        Table<GoodsTypeEnum,Long,Long> stockTable = HashBasedTable.create();
        if (!appItemIds.isEmpty()) {
            for(Long id:appItemIds){
                Long stock = goodsBatchService.getSumBatchStock(GoodsTypeEnum.APP, id);
                stockTable.put(GoodsTypeEnum.APP,id,stock);
            }
        }
        if (!itemIds.isEmpty()) {
            for(Long id:itemIds){
                Long stock = goodsBatchService.getSumBatchStock(GoodsTypeEnum.DUIBA, id);
                stockTable.put(GoodsTypeEnum.DUIBA,id,stock);
            }
        }
        for (ItemKeyDto itemKey : itemKeyDtos) {
            if (ItemKeyUtils.isGoodsCoupon(itemKey)) {
                if (itemKey.isSelfAppItemMode()) {
                    Long stock = stockTable.get(GoodsTypeEnum.APP,itemKey.getAppItem().getId());
                    itemKey.getAppItem().setRemaining(stock.intValue());
                } else if (itemKey.isDuibaAppItemMode() || itemKey.isItemMode()) {
                    Long stock = stockTable.get(GoodsTypeEnum.DUIBA,itemKey.getItem().getId());
                    itemKey.getItem().setRemaining(stock.intValue());
                }
            }
        }
    }

    @Override
    public List<ItemKeyDto> transformAppItemList(List<AppItemDto> appItemList) {
        List<Long> itemIds = new ArrayList<>();
        for (AppItemDto appItem : appItemList) {
            if (appItem.getItemId() != null) {
                itemIds.add(appItem.getItemId());
            }
        }
        Map<Long, ItemDto> itemId2ItemMap = new HashMap<>();
        if (!itemIds.isEmpty()) {
            List<ItemDto> items = itemService.findHomeItems(itemIds);
            for (ItemDto item : items) {
                itemId2ItemMap.put(item.getId(),item);
            }
        }
        List<ItemKeyDto> itemKeys = new ArrayList<>();
        for (AppItemDto appItemDO : appItemList) {
            if(appItemDO.getItemId()==null){
                itemKeys.add(new ItemKeyDto(appItemDO,null));
            }else{
                ItemDto item = itemId2ItemMap.get(appItemDO.getItemId());
                if(item == null || !item.getEnable()||item.getDeleted()){
                    continue;
                }
                itemKeys.add(new ItemKeyDto(appItemDO,item));
            }
        }
        //设置商品中心优惠券库存
        batchFindGoodsCouponStock(itemKeys);
        return itemKeys;
    }

    @Override
    public List<ItemKeyDto> getBatchItemKeyByAppItemIds(List<Long> appItemIds) {
        List<AppItemDto> list = appItemService.findByIds(appItemIds);
        return transformAppItemList(list);
    }

    @Override
    public ItemKeyDto transformAppItem(AppItemDto appItem) {
        if(appItem==null){
            return null;
        }
        List<AppItemDto> appItemDtolist = Lists.newArrayList(appItem);
        return transformAppItemList(appItemDtolist).get(0);
    }

    @Override
    public List<ItemKeyDto> transformItemList(List<ItemDto> itemDtoList){
        List<ItemKeyDto> itemKeys = new ArrayList<>();
        for (ItemDto item : itemDtoList) {
            itemKeys.add(new ItemKeyDto(null,item));
        }
        batchFindGoodsCouponStock(itemKeys);
        return itemKeys;
    }

    @Override
    public ItemKeyDto transformItem(ItemDto item) {
        if(item==null){
            return null;
        }
        List<ItemDto> itemDtolist = Lists.newArrayList(item);
        return transformItemList(itemDtolist).get(0);
    }

    @Override
    public ItemKeyDto getItemKey(Long appItemId){
        AppItemDto appItem = appItemService.find(appItemId);
        return transformAppItem(appItem);
    }

    @Override
    public ItemKeyDto getItemKey(Long appId, Long itemId) {
        AppItemDto appItem = appItemService.findByAppIdAndItemId(appId,itemId);
        return transformAppItem(appItem);
    }
}
