package cn.com.duiba.goods.center.biz.dao;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;

import java.util.List;

/**
 * Created by liuyao on 2016/11/16.
 */
public interface AppItemDao {

    /**
     * 根据id获取商品信息
     * @param id
     * @return
     */
    AppItemDto find(Long id);

    /**
     * 根据ids批量获取商品信息
     * @param ids
     * @return
     */
    List<AppItemDto> findByIds(List<Long> ids);

    /**
     * 根据appId和itemId获取商品信息
     * @param appId
     * @param itemId
     * @return
     */
    AppItemDto findByAppIdAndItemId(Long appId, Long itemId);

    /**
     * 获取的首展示的兑换项
     *
     * @param appId
     * @return
     */
    List<AppItemDto> findhomeAppItemNeed(Long appId);

    /**
     * 获取参加了某个活动的且打开商品区入口的appId
     *
     * @param activityId
     * @param type
     * @return
     */
    List<Long> findAppIdsByInActivityId(Long activityId, Integer type);

    /**
     * 获取某个活动下的所有
     *
     * @param relationId
     * @return
     */
    List<Long> findAppIdsByActivityId(Long relationId);

    /**
     * 查询将将某些兑吧商品入库的appId
     *
     * @param itemIds
     * @return
     */
    List<Long> findAppIdByItemIds(List<Long> itemIds);

    /**
     * 根据appId和ids查询商品项
     *
     * @param appId
     * @param status
     * @param ids
     * @return
     */
    List<AppItemDto> findAppItemsByAppIdAndIds(Long appId, String status, List<Long> ids);

    /**
     * 查询入库商品对应的appIds
     *
     * @param ids
     * @return
     */
    List<Long> findAppIdsByIds(List<Long> ids);

}
