package cn.com.duiba.goods.center.biz.dao;

import java.util.List;
import java.util.Map;

/**
 * Created by liuyao on 2016/11/17.
 */
public interface ItemAutoRecommendDao{
    /**
     * 查询所有自动推荐非定向兑换项
     * @param autoRecommend
     * @param enable
     * @return
     */
    public List<Long> findItemAutoRecommendNoSpecify(Boolean autoRecommend, Boolean enable);

    /**
     * 查询非定向自动推荐项
     * 必须参数：auto_recommend自动推荐标记，可传入参数：type,inType(list类型type的集合)
     * @param params
     * @return
     */
    public List<Long> findItemAutoRecommendNoSpecifyMap(Map<String, Object> params);
    /**
     * 查询被APP标签屏蔽的兑换项
     * @param appId
     * @return
     */
    public List<Long> findItemAppTagsMasking(Long appId);
    /**
     * 查询开发者上架的兑换项
     * @param
     * @param
     * @return
     */
    public List<Long> findItemInApp(Long appId,Boolean isOwner,Boolean deleted);
    /**
     * 查询app定向的兑换项
     * @param appId
     * @return
     */
    public List<Long> findItemSpecify(Long appId);

    /**
     * 查询定向推荐项
     * 必须参数:appId,可选参数：type,inType(list类型type的集合)
     * @param params
     * @return
     */
    public List<Long> findItemSpecifyMap(Map<String, Object> params);

}
