/**
 * Project Name:goods-center-biz
 * File Name:PCGSellerGoodsDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年5月26日下午5:49:07
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao;

import java.util.List;

import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;

/**
 * ClassName:PCGSellerGoodsDao <br/>
 * Date:     2016年5月26日 下午5:49:07 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface PCGSellerGoodsDao {

    int selectMaxPayloadBySellerId(long sellerId);
    
    int insertGoods2Seller(long pcgId,long sellerId,int payload);
    
    int deleteGoods2Seller(long pcgId,long sellerId);
    
    int deleteSellerRelation(long sellerId);
    
    int deleteGoodsRelation(long pcgId);
    
    List<PCGSellerGoodsEntity> selectBySeller(long sellerId);
    
    List<PCGSellerGoodsEntity> selectByGoods(long pcgId);
    
    /**
     * 更新一条记录的权重
     *
     * @author xuhengfei
     * @param sellerId
     * @param pcgId
     * @param payload
     * @return
     * @since JDK 1.6
     */
    public int updatePayload(long sellerId,long pcgId,int payload);
}

