/**
 * Project Name:goods-center-biz
 * File Name:PlatformCouponGoodsDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年5月19日下午4:10:54
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao;

import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGEditDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGInsertDto;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;

/**
 * ClassName:PlatformCouponGoodsDao <br/>
 * Date:     2016年5月19日 下午4:10:54 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface PlatformCouponGoodsDao {
    
    
    /**
     * 
     * insert:插入一条平台券商品信息. <br/>
     *
     * @author xuhengfei
     * @param entity 商品对象
     * @return 影响行数
     * @since JDK 1.6
     */
    int insert(PCGInsertDto entity);
    /**
     * 
     * markDelete:标记删除一个平台券商品. <br/>
     *
     * @author xuhengfei
     * @param pcgId 平台券id
     * @return 影响行数
     * @since JDK 1.6
     */
    int markDelete(Long pcgId);
    /**
     * 
     * updateStatusOnShelf:更新商品为上架状态. <br/>
     *
     * @author xuhengfei
     * @param pcgId 平台券id
     * @return 影响行数
     * @since JDK 1.6
     */
    int updateStatusOnShelf(Long pcgId);
    
    /**
     * 
     * updateStatusOffShelf:更新商品为下架状态. <br/>
     *
     * @author xuhengfei
     * @param pcgId 平台券id
     * @return 影响行数
     * @since JDK 1.6
     */
    int updateStatusOffShelf(Long pcgId);
    /**
     * 编辑商品
     * 所有字段都会保存，包括null也会保存
     *
     * @author xuhengfei
     * @param pcgId 平台券id
     * @return 影响行数
     * @since JDK 1.6
     */
    int updateEditGoods(Long pcgId,PCGEditDto goods);
    /**
     * 更新商品的券类型
     *
     * @author xuhengfei
     * @param pcgId 平台券id
     * @param couponType 券类型
     * @return 影响行数
     * @since JDK 1.6
     */
    int updateCouponType(Long pcgId,int couponType);
    /**
     * 根据名称搜索
     *
     * @author xuhengfei
     * @param namelike 名称关键字
     * @return 结果集
     * @since JDK 1.6
     */
    List<PlatformCouponGoodsEntity> selectSearchByName(String namelike);
    /**
     * 根据平台券id查询
     *
     * @author xuhengfei
     * @param pcgId 平台券id
     * @return 商品信息
     * @since JDK 1.6
     */
    PlatformCouponGoodsEntity selectByPcgId(long pcgId);
    /**
     * 查询商品，包含已删除商品
     *
     * @author xuhengfei
     * @param pcgId 平台券id
     * @return 商品信息
     * @since JDK 1.6
     */
    PlatformCouponGoodsEntity selectByPcgIdIncludeDeleted(long pcgId);
    /**
     * 批量查询商品
     *
     * @author xuhengfei
     * @param pcgIds 平台券id列表
     * @return 结果集
     * @since JDK 1.6
     */
    List<PlatformCouponGoodsEntity> selectByIds(List<Long> pcgIds);
    /**
     * 根据状态和名称查询结果集数量
     *
     * @author xuhengfei
     * @param name 名称
     * @param pcgStatus 状态
     * @return 数量
     * @since JDK 1.6
     */
    int selectCountBySearch(String name,Integer pcgStatus);
    /**
     * 查询列表
     *
     * @author xuhengfei
     * @param name 名称
     * @param pcgStatus 状态
     * @param start 开始数
     * @param limit 最大返回数
     * @return 结果集
     * @since JDK 1.6
     */
    List<PlatformCouponGoodsEntity> selectBySearch(String name,Integer pcgStatus,int start,int limit);
    /**
     * 更新位运算字段
     *
     * @author xuhengfei
     * @param pcgId 平台券商品id
     * @param switches 位运算字段
     * @return 影响行数
     * @since JDK 1.6
     */
    int updateSwitches(Long pcgId,Long switches);
}

