package cn.com.duiba.goods.center.biz.dao.impl;


import cn.com.duiba.goods.center.api.remoteservice.dto.AddrLimitDto;
import cn.com.duiba.goods.center.biz.dao.AddrLimitDao;
import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
/**
 * Created by xiaoxuda on 2016/11/17.
 */
@Repository("addrLimitDao")
public class AddrLimitDaoImpl extends BaseCreditsDao implements AddrLimitDao{

	public List<AddrLimitDto> findAddrLimitByAppItemId(Long appItemId){
		return getSqlSession().selectList(getStamentNameSpace("findAddrLimitByAppItemId"), appItemId);
	}

	public List<AddrLimitDto> findAddrLimitByAppItemIds(List<Long> appItemIds){
		if(appItemIds==null||appItemIds.size()<1){
			return new ArrayList<AddrLimitDto>();
		}
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("appItemIds", appItemIds);
		return getSqlSession().selectList(getStamentNameSpace("findAddrLimitByAppItemIds"), map);
	}

	public List<AddrLimitDto> findAddrLimitByItemId(Long itemId){
		return getSqlSession().selectList(getStamentNameSpace("findAddrLimitByItemId"), itemId);
	}

	public List<AddrLimitDto> findAddrLimitByItemIds(List<Long> itemIds){
		if(itemIds==null||itemIds.size()<1){
			return new ArrayList<AddrLimitDto>();
		}
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("itemIds", itemIds);
		return getSqlSession().selectList(getStamentNameSpace("findAddrLimitByItemIds"), map);
	}

	public Integer findTypeByAppItemId(Long appItemId){
		return getSqlSession().selectOne(getStamentNameSpace("findTypeByAppItemId"),appItemId);
	}

	public Integer findTypeByItemId(Long itemId){
		return getSqlSession().selectOne(getStamentNameSpace("findTypeByItemId"),itemId);
	}

	public void batchInsertAddrLimit(List<AddrLimitDto> addrLimitList){
		Map<String,Object> paramMap = new HashMap<String,Object>();
		paramMap.put("addrLimitList", addrLimitList);
		getSqlSession().insert(getStamentNameSpace("batchInsertAddrLimit"), paramMap);
	}

	public void deleteAddrLimit(Long itemId,Long appItemId){
		Map<String,Object> paramMap = new HashMap<String,Object>();
		paramMap.put("itemId", itemId);
		paramMap.put("appItemId", appItemId);
		getSqlSession().delete(getStamentNameSpace("deleteAddrLimit"), paramMap);
	}
}
