package cn.com.duiba.goods.center.biz.dao.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.biz.dao.AppItemDao;
import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liuyao on 2016/11/16.
 */
@Repository
public class AppItemDaoImpl extends BaseCreditsDao implements AppItemDao {

    @Override
    public AppItemDto find(Long id) {
        return getSqlSession().selectOne(this.getStamentNameSpace("find"), id);
    }

    @Override
    public List<AppItemDto> findByIds(List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ids", ids);
        return getSqlSession().selectList(this.getStamentNameSpace("findByIds"), paramMap);
    }

    @Override
    public AppItemDto findByAppIdAndItemId(Long appId, Long itemId) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("appId", appId);
        params.put("itemId", itemId);
        return getSqlSession().selectOne(this.getStamentNameSpace("findByAppIdAndItemId"), params);
    }

    @Override
    public List<AppItemDto> findhomeAppItemNeed(Long appId) {
        return getSqlSession().selectList(this.getStamentNameSpace("findhomeAppItemNeed"), appId);
    }

    @Override
    public List<Long> findAppIdsByInActivityId(Long activityId, Integer type) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("activityId", activityId);
        paramMap.put("type", type);
        return getSqlSession().selectList(this.getStamentNameSpace("findAppIdsByInActivityId"), paramMap);
    }

    @Override
    public List<Long> findAppIdsByActivityId(Long relationId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("relationId", relationId);
        return getSqlSession().selectList(this.getStamentNameSpace("findAppIdsByActivityId"), paramMap);
    }

    @Override
    public List<Long> findAppIdByItemIds(List<Long> itemIds) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("itemIds", itemIds);
        return getSqlSession().selectList(this.getStamentNameSpace("findAppIdByItemIds"), paramMap);
    }

    @Override
    public List<AppItemDto> findAppItemsByAppIdAndIds(Long appId, String status, List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        paramMap.put("status",status);
        paramMap.put("ids", ids);
        return getSqlSession().selectList(this.getStamentNameSpace("findAppItemsByAppIdAndIds"), paramMap);
    }

    @Override
    public List<Long> findAppIdsByIds(List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ids", ids);
        return getSqlSession().selectList(this.getStamentNameSpace("findAppIdsByIds"), paramMap);
    }
}
