package cn.com.duiba.goods.center.biz.dao.impl;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.ItemAutoRecommendDao;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liuyao on 2016/11/17.
 */
@Repository
public class ItemAutoRecommendDaoImpl extends BaseCreditsDao implements ItemAutoRecommendDao {

    @Override
    public List<Long> findItemAutoRecommendNoSpecify(Boolean autoRecommend, Boolean enable) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("autoRecommend", autoRecommend);
        queryMap.put("enable", enable);
        return getSqlSession().selectList(this.getStamentNameSpace("findItemAutoRecommendNoSpecify"),queryMap);
    }

    @Override
    public List<Long> findItemAutoRecommendNoSpecifyMap(Map<String, Object> params) {
        return getSqlSession().selectList(this.getStamentNameSpace("findItemAutoRecommendNoSpecifyMap"), params);
    }

    @Override
    public List<Long> findItemAppTagsMasking(Long appId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        return getSqlSession().selectList(this.getStamentNameSpace("findItemAppTagsMasking"), queryMap);
    }

    @Override
    public List<Long> findItemInApp(Long appId, Boolean isOwner, Boolean deleted) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        queryMap.put("isOwner", isOwner);
        queryMap.put("deleted", deleted);
        return getSqlSession().selectList(this.getStamentNameSpace("findItemInApp"), queryMap);
    }

    @Override
    public List<Long> findItemSpecify(Long appId) {
        Map<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("appId", appId);
        return getSqlSession().selectList(this.getStamentNameSpace("findItemSpecify"), queryMap);
    }

    @Override
    public List<Long> findItemSpecifyMap(Map<String, Object> params) {
        return getSqlSession().selectList(this.getStamentNameSpace("findItemSpecifyMap"), params);
    }
}
