/**
 * Project Name:goods-center-biz
 * File Name:ItemDaoImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.dao.impl
 * Date:2016年6月20日上午11:37:10
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.ItemDao;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ClassName:ItemDaoImpl <br/>
 * Date:     2016年6月20日 上午11:37:10 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository("itemDao")
public class ItemDaoImpl extends BaseCreditsDao implements ItemDao{

    @Override
    public ItemEntity find(long id) {
        return getSqlSession().selectOne(getStamentNameSpace("find"),id);
    }

    @Override
    public List<ItemEntity> findLinkActivityCouponItemsByIds(List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("ids", ids);
        return getSqlSession().selectList(getStamentNameSpace("findLinkActivityCouponItemsByIds"), paramMap);
    }

    @Override
    public List<ItemEntity> findAllByIds(List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("ids", ids);
        return getSqlSession().selectList(getStamentNameSpace("findAllByIds"), paramMap);
    }

	@Override
	public Integer updateEnable(Long itemId, Boolean enable) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("itemId", itemId);
		paramMap.put("enable", enable);
		return getSqlSession().update(getStamentNameSpace("updateEnable"), paramMap);
	}

    @Override
    public List<ItemDto> findHomeItems(List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("ids", ids);
        return getSqlSession().selectList(getStamentNameSpace("findHomeItems"), paramMap);
    }
}

