package cn.com.duiba.goods.center.biz.remoteservice.custom;

import cn.com.duiba.goods.center.api.remoteservice.RemoteItemBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.ItemLinkActivityCouponDto;
import cn.com.duiba.goods.center.biz.service.item.ActivityItemService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("remoteItemBackendService")
public class RemoteItemBackendServiceImpl implements RemoteItemBackendService {

    private final static Logger LOGGER = LoggerFactory.getLogger(RemoteItemBackendServiceImpl.class);

    @Autowired
    private ActivityItemService activityItemService;

    @Override
    public DubboResult<List<ItemLinkActivityCouponDto>> getLinkActivityCouponItems(String text) {
        try {
            List<ItemLinkActivityCouponDto> result = activityItemService.getLinkActivityCouponItems(text);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("getLinkActivityCouponItems error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
