package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.RemoteAddrLimitService;
import cn.com.duiba.goods.center.api.remoteservice.dto.AddrLimitDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.bo.AddrLimitBO;
import cn.com.duiba.goods.center.biz.service.AddrLimitService;
import cn.com.duiba.service.domain.dataobject.IpLibraryDO;
import cn.com.duiba.service.remoteservice.RemoteIpLibraryService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

import static cn.com.duiba.wolf.dubbo.DubboResult.successResult;

/**
 * Created by xiaoxuda on 2016/11/17.
 */
@Service("remoteAddrLimitService")
public class RemoteAddrLimitServiceImpl implements RemoteAddrLimitService {
    @Autowired
    private AddrLimitBO addrLimitBO;

    @Override
    public DubboResult<List<ItemKeyDto>> getItemCanPassAddrLimit(List<ItemKeyDto> items, String ip) {
        return DubboResult.successResult(addrLimitBO.getItemCanPassAddrLimit(items,ip));
    }
}
