package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.goods.center.api.remoteservice.RemoteGoodsAppItemExtraService;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemExtraDto;
import cn.com.duiba.goods.center.biz.service.item.AppItemExtraService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by xiaoxuda on 2016/12/6.
 */
@Service("remoteGoodsAppItemExtraService")
public class RemoteGoodsAppItemExtraServiceImpl implements RemoteGoodsAppItemExtraService {
    @Autowired
    private AppItemExtraService appItemExtraService;

    @Override
    public DubboResult<AppItemExtraDto> findByAppItemId(Long appItemId) {
        return DubboResult.successResult(appItemExtraService.findByAppItemId(appItemId));
    }

    @Override
    public DubboResult<Integer> insert(AppItemExtraDto appItemExtra) {
        return DubboResult.successResult(appItemExtraService.insert(appItemExtra));
    }

    @Override
    public DubboResult<Integer> updateByAppItemId(AppItemExtraDto appItemExtra) {
        return DubboResult.successResult(appItemExtraService.updateByAppItemId(appItemExtra));
    }

    @Override
    public DubboResult<Integer> deleteByAppItemId(Long appItemId) {
        return DubboResult.successResult(appItemExtraService.deleteByAppItemId(appItemId));
    }

    @Override
    public DubboResult<Integer> insertOrUpdateByAppItemId(AppItemExtraDto appItemExtra) {
        return DubboResult.successResult(appItemExtraService.insertOrUpdateByAppItemId(appItemExtra));
    }


}
