package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteGoodsItemLimitService;
import cn.com.duiba.goods.center.biz.service.item.ItemLimitService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("remoteGoodsItemLimitService")
public class RemoteGoodsItemLimitServiceImpl implements RemoteGoodsItemLimitService {

    private static Logger LOGGER = LoggerFactory.getLogger(RemoteGoodsItemLimitServiceImpl.class);

    @Autowired
    private ItemLimitService itemLimitService;

    @Override
    public DubboResult<Boolean> addQuantityLimitCounter(ItemKeyDto itemKey) {
        try {
            Boolean result = itemLimitService.addQuantityLimitCounter(itemKey);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("addQuantityLimitCounter error, ", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> subQuantityLimitCounter(ItemKeyDto itemKey) {
        try {
            Boolean result = itemLimitService.subQuantityLimitCounter(itemKey);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("subQuantityLimitCounter error, ", e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
