package cn.com.duiba.goods.center.biz.remoteservice.item;

import cn.com.duiba.goods.center.api.remoteservice.RemoteItemKeyService;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.bo.AppItemClassifyRelationBO;
import cn.com.duiba.goods.center.biz.bo.item.ItemKeyBo;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by liuyao on 2016/11/16.
 */
@Service
public class RemoteItemKeyServiceImpl implements RemoteItemKeyService {
    @Autowired
    private ItemKeyBo itemKeyBo;

    @Autowired
    private AppItemClassifyRelationBO appItemClassifyRelationBO;

    @Override
    public DubboResult<List<ItemKeyDto>> findHomeItemKey(Long appId) {
        return DubboResult.successResult(itemKeyBo.findHomeItemKeyCacheList(appId));
    }

    @Override
    public DubboResult<List<ItemKeyDto>> getBatchItemKeyByAppItemIds(List<Long> appItemIds) {
        return DubboResult.successResult(itemKeyBo.getBatchItemKeyByAppItemIds(appItemIds));
    }

    @Override
    public DubboResult<ItemKeyDto> getItemKey(Long appItemId) {
        return DubboResult.successResult(itemKeyBo.getItemKey(appItemId));
    }

    @Override
    public DubboResult<ItemKeyDto> getItemKey(Long appId,Long itemId) {
        return DubboResult.successResult(itemKeyBo.getItemKey(appId,itemId));
    }

    @Override
    public DubboResult<List<ItemKeyDto>> findItemKeysWithClassifyPayLoad(Long appId, Long classifyId, String status) {
        List<AppItemDto> appItems = appItemClassifyRelationBO.findAppItemsWithClassifyPayLoad(classifyId, appId, status);

        return DubboResult.successResult(itemKeyBo.transformAppItemList(appItems));
    }
}
