package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.AddrLimitDto;
import cn.com.duiba.goods.center.biz.dao.AddrLimitDao;
import cn.com.duiba.goods.center.biz.service.AddrLimitService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/5/25.
 */
@Service
public class AddrLimitServiceImpl implements AddrLimitService {
    @Resource
    private AddrLimitDao addrLimitDao;

    @Override
    public List<AddrLimitDto> findAddrLimitByAppItemId(Long appItemId) {
        return addrLimitDao.findAddrLimitByAppItemId(appItemId);
    }

    @Override
    public List<AddrLimitDto> findAddrLimitByItemId(Long itemId) {
        return addrLimitDao.findAddrLimitByItemId(itemId);
    }

    @Override
    public Integer findTypeByAppItemId(Long appItemId) {
        return addrLimitDao.findTypeByAppItemId(appItemId);
    }

    @Override
    public Integer findTypeByItemId(Long itemId) {
        return addrLimitDao.findTypeByItemId(itemId);
    }

    @Override
    public void batchInsertAddrLimit(List<AddrLimitDto> addrLimitList) {
        addrLimitDao.batchInsertAddrLimit(addrLimitList);
    }

    @Override
    public void deleteAddrLimit(Long itemId, Long appItemId) {
        addrLimitDao.deleteAddrLimit(itemId, appItemId);
    }

	@Override
	public List<AddrLimitDto> findAddrLimitByAppItemIds(List<Long> appItemIds) {
		return addrLimitDao.findAddrLimitByAppItemIds(appItemIds);
	}

	@Override
	public List<AddrLimitDto> findAddrLimitByItemIds(List<Long> itemIds) {
		return addrLimitDao.findAddrLimitByItemIds(itemIds);
	}
}
