package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.goods.center.biz.dao.ItemAutoRecommendDao;
import cn.com.duiba.goods.center.biz.service.item.ItemAutoRecommendService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by liuyao on 2016/11/17.
 */
@Service
public class ItemAutoRecommendServiceImpl implements ItemAutoRecommendService {

    @Autowired
    private ItemAutoRecommendDao itemAutoRecommendDao;

    @Override
    public List<Long> findItemAutoRecommendNoSpecify(Boolean autoRecommend, Boolean enable) {
        return itemAutoRecommendDao.findItemAutoRecommendNoSpecify(autoRecommend,enable);
    }

    @Override
    public List<Long> findItemSpecify(Long appId) {
        return itemAutoRecommendDao.findItemSpecify(appId);
    }

    @Override
    public List<Long> findItemAppTagsMasking(Long appId) {
        return itemAutoRecommendDao.findItemAppTagsMasking(appId);
    }

    @Override
    public List<Long> findItemInApp(Long appId, Boolean isOwner, Boolean deleted) {
        return itemAutoRecommendDao.findItemInApp(appId,isOwner,deleted);
    }
}
