package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.dao.ItemDao;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import com.google.common.base.Preconditions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * itemservice
 * Created by gyf .
 * 16/10/25 .
 */
@Service("itemService")
public class ItemServiceImpl implements ItemService {

    @Autowired
    private ItemDao itemDao;

    @Autowired
    private GoodsBatchService goodsBatchService;

    @Override
    public ItemEntity findCorrectStockItem(Long id) {
        Preconditions.checkNotNull(id, "id 不能为 null");
        ItemEntity item = itemDao.find(id);
        if (item == null) {
            return null;
        }
        if (item.isOpTypeItem(ItemDto.OpTypeGoodsCoupon)) {
            Long stock = goodsBatchService.getSumBatchStockBatch(GoodsTypeEnum.DUIBA, item.getId());
            item.setRemaining(Integer.valueOf(stock.toString()));
        }
        return item;
    }

    @Override
    public List<ItemDto> findHomeItems(List<Long> itemIds) {
        return itemDao.findHomeItems(itemIds);
    }

    @Override
    public List<ItemEntity> findAllByIds(List<Long> ids) {
        if(ids==null || ids.isEmpty()){
            return Collections.emptyList();
        }
        return itemDao.findAllByIds(ids);
    }
}
