package cn.com.duiba.goods.center.biz.bo.item.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.bo.item.ItemAutoRecommendBo;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by liuyao on 2016/11/17.
 */
@Service
public class ItemAutoRecommendBoImpl implements ItemAutoRecommendBo {
	@Autowired
	private ItemService itemService;

	@Override
	public List<ItemKeyDto> findHomeAutoRecommend(Long appId, Integer size) {
		List<ItemEntity> items = itemService.findAutoRecommend(appId);
		items = items.subList(0, Math.min(items.size(), size));
		List<ItemKeyDto> dtos = new ArrayList<>();
		for (ItemEntity entity : items) {
			dtos.add(new ItemKeyDto(null, BeanUtils.copy(entity, ItemDto.class), appId));
		}
		return dtos;
	}

}
