/**
 * Project Name:goods-center-biz
 * File Name:PCGUtilBO.java
 * Package Name:cn.com.duiba.goods.center.biz.bo.pcg
 * Date:2016年6月28日下午2:14:26
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.bo.pcg;

import java.util.List;

import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.common.GoodsException;

/**
 * ClassName:PCGUtilBO <br/>
 * Function: 平台券辅助类服务. <br/>
 * Date:     2016年6月28日 下午2:14:26 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface PCGUtilBO {

	/**
	 * canTakePlatformCouponGoods
	 * @param pcgId
	 * @param appId
	 * @param consumerId
	 * @return
	 * @throws GoodsException
	 */
    public boolean canTakePlatformCouponGoods(long pcgId, long appId, long consumerId) throws GoodsException;
    
    /**
     * 是否商品在黑名单中，无法进行下单
     * @param pcg
     * @param appId
     * @return
     */
    public boolean isInBlack(PlatformCouponGoodsEntity pcg,long appId);
    
    /**
     * checkStockEnough
     * @param pcgId
     * @param appId
     * @param consumerId
     * @return
     */
    public boolean checkStockEnough(long pcgId, long appId, long consumerId);
    
    /**
     * 结合商品id和app，查询库存
     *
     * @author xuhengfei
     * @param pcgId
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public long getStockInApp(long pcgId, long appId);
    /**
     * @deprecated
     * 计算商品的积分价格
     *
     * @author xuhengfei
     * @param pcgId
     * @param appId
     * @param consumerId
     * @return
     * @since JDK 1.6
     */
    @Deprecated
    public Long calcultePCGCredits(long pcgId, long appId, long consumerId);
    
    /**
     * 计算商品的积分价格
     * @param pcgId
     * @param appId
     * @param consumerId
     * @param appCreditsRate
     * @return
     */
    public Long calcultePCGCredits(long pcgId, long appId, long consumerId,  Long appCreditsRate);

	/**
     * 是否商品在黑名单中
     *
     * @param goods   app下屏蔽券列表
     * @param cates   app下屏蔽分类列表
     * @param sellers app下屏蔽商品列表
     * @param pcg
     * @param appId
     * @return
     */
    public boolean isInBlackForSpecial(List<PlatformCouponGoodsEntity> goods, List<PCGCategoryEntity> cates, List<PCGSellerEntity> sellers, PlatformCouponGoodsEntity pcg, long appId);
}

