package cn.com.duiba.goods.center.biz.dao;


import cn.com.duiba.goods.center.api.remoteservice.dto.AddrLimitDto;

import java.util.List;
/**
 * Created by xiaoxuda on 2016/11/17.
 */
public interface AddrLimitDao {

	/**
	 * 根据appItemId查询对应的地域限制
	 * @param appItemId
	 * @return
	 */
	public List<AddrLimitDto> findAddrLimitByAppItemId(Long appItemId);

	/**
	 * 根据appItemIds批量查询对应的地域限制
	 * @param appItemIds
	 * @return
	 */
	public List<AddrLimitDto> findAddrLimitByAppItemIds(List<Long> appItemIds);

	/**
	 * 根据itemId查询对应的地域限制
	 * @param itemId
	 * @return
	 */
	public List<AddrLimitDto> findAddrLimitByItemId(Long itemId);

	/**
	 * 根据itemIds批量查询对应的地域限制
	 * @param itemId
	 * @return
	 */
	public List<AddrLimitDto> findAddrLimitByItemIds(List<Long> itemId);

	/**
	 * 根据appItemId查询地域限制类型（黑白or名单）
	 * @param appItemId
	 * @return
	 */
	public Integer findTypeByAppItemId(Long appItemId);

	/**
	 * 根据itemId查询地域限制类型（黑白or名单）
	 * @param itemId
	 * @return
	 */
	public Integer findTypeByItemId(Long itemId);

	/**
	 * 批量插入地域限制
	 * @param addrLimitList
	 */
	public void batchInsertAddrLimit(List<AddrLimitDto> addrLimitList);

	/**
	 * 根据itemId,appItemId删除限制信息
	 * @param itemId
	 * @param appItemId
	 */
	public void deleteAddrLimit(Long itemId, Long appItemId);
}
