package cn.com.duiba.goods.center.biz.dao;

import java.util.HashMap;
import java.util.Map;

import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * BaseDao
 */
public class BaseDao {

    @Autowired
    @Qualifier("sqlSessionTemplate")
    protected SqlSessionTemplate sqlSession;

    protected SqlSessionTemplate getSqlSession() {
        return sqlSession;
    }

    protected String getStamentNameSpace(String method) {
        return getClass().getName() + "." + method;
    }
    
    protected Map<String, Object> getBlankParams(){
        return new HashMap<>();
    }
}
