package cn.com.duiba.goods.center.biz.dao.impl;


import cn.com.duiba.goods.center.api.remoteservice.dto.AddrLimitDto;
import cn.com.duiba.goods.center.biz.dao.AddrLimitDao;
import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
/**
 * Created by xiaoxuda on 2016/11/17.
 */
@Repository("addrLimitDao")
public class AddrLimitDaoImpl extends BaseCreditsDao implements AddrLimitDao{

	@Override
	public List<AddrLimitDto> findAddrLimitByAppItemId(Long appItemId){
		return getSqlSession().selectList(getStamentNameSpace("findAddrLimitByAppItemId"), appItemId);
	}

	@Override
	public List<AddrLimitDto> findAddrLimitByAppItemIds(List<Long> appItemIds){
		if(appItemIds==null||appItemIds.isEmpty()){
			return new ArrayList<>();
		}
		Map<String, Object> map = new HashMap<>();
		map.put("appItemIds", appItemIds);
		return getSqlSession().selectList(getStamentNameSpace("findAddrLimitByAppItemIds"), map);
	}

	@Override
	public List<AddrLimitDto> findAddrLimitByItemId(Long itemId){
		return getSqlSession().selectList(getStamentNameSpace("findAddrLimitByItemId"), itemId);
	}

	@Override
	public List<AddrLimitDto> findAddrLimitByItemIds(List<Long> itemIds){
		if(itemIds==null||itemIds.isEmpty()){
			return new ArrayList<>();
		}
		Map<String, Object> map = new HashMap<>();
		map.put("itemIds", itemIds);
		return getSqlSession().selectList(getStamentNameSpace("findAddrLimitByItemIds"), map);
	}

	@Override
	public Integer findTypeByAppItemId(Long appItemId){
		return getSqlSession().selectOne(getStamentNameSpace("findTypeByAppItemId"),appItemId);
	}

	@Override
	public Integer findTypeByItemId(Long itemId){
		return getSqlSession().selectOne(getStamentNameSpace("findTypeByItemId"),itemId);
	}

	@Override
	public void batchInsertAddrLimit(List<AddrLimitDto> addrLimitList){
		Map<String,Object> paramMap = new HashMap<>();
		paramMap.put("addrLimitList", addrLimitList);
		getSqlSession().insert(getStamentNameSpace("batchInsertAddrLimit"), paramMap);
	}

	@Override
	public void deleteAddrLimit(Long itemId,Long appItemId){
		Map<String,Object> paramMap = new HashMap<>();
		paramMap.put("itemId", itemId);
		paramMap.put("appItemId", appItemId);
		getSqlSession().delete(getStamentNameSpace("deleteAddrLimit"), paramMap);
	}
}
