package cn.com.duiba.goods.center.biz.dao.item;

import java.util.Date;
import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;

/**
 * 
 * AppItemDao
 *
 */
public interface AppItemDao {
	
	/**
	 * 根据ID查询应用商品信息
	 * 
	 * @param id
	 * @return
	 */
	public AppItemEntity find(Long id);

	/**
	 * 根据ID集合查询应用商品信息
	 * 
	 * @param ids
	 * @return
	 */
	public List<AppItemEntity> findByIds(List<Long> ids);
	
	/**
	 * 根据itemID查询
	 * @param appId
	 * @param itemId
	 * @return
	 */
	public AppItemEntity findByAppIdAndItemId(Long appId, Long itemId);

	/**
	 * 创建商品
	 * 
	 * @param appItemEntity
	 * @return
	 */
	public void insert(AppItemEntity appItemEntity);

	/**
	 * 修改商品
	 * 
	 * @param appItemEntity
	 * @return
	 */
	public Integer update(AppItemEntity appItemEntity);

	/**
	 * 删除商品
	 *
	 * @param appId
	 * @param appItemId
	 */
	public Integer delete(Long appId, Long appItemId);

	/**
	 * 批量删除商品
	 * 
	 * @param appId
	 * @param appItemId
	 * @return
	 */
	public Integer deleteByIds(Long appId, List<Long> appItemId);

	/**
	 * 修改状态
	 * 
	 * @param appId
	 * @param appItemId
	 * @param status
	 *            off:下架 on:上架
	 * @return
	 */
	public Integer updateStatus(Long appId, Long appItemId, String status);

	/**
	 * 批量修改状态
	 * 
	 * @param appId
	 * @param appItemIds
	 * @param status
	 *            off:下架 on:上架
	 * @return
	 */
	public Integer updateStatusByIds(Long appId, List<Long> appItemIds, String status);

	/**
	 * 减一个库存
	 * 
	 * @param appItemId
	 * @return
	 */
	public Integer decrStock(Long appItemId);

	/**
	 * 加一个库存
	 * 
	 * @param appItemId
	 * @param bizId
	 * @return
	 */
	public Integer incrStock(Long appItemId);

	/**
	 * 编辑商品，增加库存
	 * 
	 * @param appItemId
	 * @param number
	 * @return
	 */
	public Integer appendStock(Long appItemId, Long number);

	/**
	 * 编辑商品，减少库存
	 * 
	 * @param appItemId
	 * @param number
	 * @return
	 */
	public Integer deductStock(Long appItemId, Long number);
	
	/**
	 * 修改库存和过期时间
	 * @param appItemId
	 * @param totalStock
	 * @param validEndDate
	 * @return
	 */
	public Integer updateRemainingAndvalidEndDate(Long appItemId, Long totalStock, Date validEndDate);
	
	/**
	 * 修改EXPIED为null
	 * 
	 * @param itemId
	 * @return
	 */
	public Integer updateExpiedAppItem(Long itemId);

	/**
	 * 修改EXPIED为null
	 * 
	 * @param appItemId
	 * @return
	 */
	public Integer updateExpiedAppItemById(Long appItemId);
	
    /**
     * 获取的首展示的兑换项
     *
     * @param appId
     * @return
     */
    List<AppItemDto> findhomeAppItemNeed(Long appId);

    /**
     * 获取参加了某个活动的且打开商品区入口的appId
     *
     * @param activityId
     * @param type
     * @return
     */
    List<Long> findAppIdsByInActivityId(Long activityId, Integer type);

    /**
     * 获取某个活动下的所有
     *
     * @param relationId
     * @return
     */
    List<Long> findAppIdsByActivityId(Long relationId);
    
    List<Long> findIdsByActivityIds(List<Long> relationIds);

    /**
     * 查询将将某些兑吧商品入库的appId
     *
     * @param itemIds
     * @return
     */
    List<Long> findAppIdByItemIds(List<Long> itemIds);

    /**
     * 根据appId和ids查询商品项
     *
     * @param appId
     * @param status
     * @param ids
     * @return
     */
    List<AppItemDto> findAppItemsByAppIdAndIds(Long appId, String status, List<Long> ids);

    /**
     * 查询入库商品对应的appIds
     *
     * @param ids
     * @return
     */
    List<Long> findAppIdsByIds(List<Long> ids);
    
    /**
     * 根据兑吧商品ID查询ID
     * @param itemId
     * @return
     */
    List<Long> findIdByItemId(Long itemId);


    public int updateStatusByActivityIds(String status, Boolean delete, List<Long> oids);
}
