package cn.com.duiba.goods.center.biz.dao.item;

import java.util.List;

/**
 * 
 * ItemAutoRecommendDao
 *
 */
public interface ItemAutoRecommendDao {

	/**
	 * 查询所有自动推荐非定向兑换项
	 * 
	 * @param autoRecommend
	 * @param enable
	 * @return
	 */
	public List<Long> findItemAutoRecommendNoSpecify(Boolean autoRecommend, Boolean enable);

	/**
	 * 查询被APP标签屏蔽的兑换项
	 * 
	 * @param appId
	 * @return
	 */
	public List<Long> findItemAppTagsMasking(Long appId);

	/**
	 * 查询开发者上架的兑换项
	 * @param appId
	 * @param isOwner
	 * @param deleted
	 * @return
	 */
	public List<Long> findItemInApp(Long appId, Boolean isOwner, Boolean deleted);

	/**
	 * 查询app定向的兑换项
	 * 
	 * @param appId
	 * @return
	 */
	public List<Long> findItemSpecify(Long appId);

}
