package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemAutoRecommendDao;

/**
 * 
 * ItemAutoRecommendDaoImpl
 *
 */
@Repository
public class ItemAutoRecommendDaoImpl extends BaseCreditsDao implements ItemAutoRecommendDao {

	private String appIdKey = "appId";
	
	@Override
	public List<Long> findItemAutoRecommendNoSpecify(Boolean autoRecommend, Boolean enable) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("autoRecommend", autoRecommend);
		queryMap.put("enable", enable);
		return getSqlSession().selectList(getStamentNameSpace("findItemAutoRecommendNoSpecify"), queryMap);
	}

	@Override
	public List<Long> findItemAppTagsMasking(Long appId) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put(appIdKey, appId);
		return getSqlSession().selectList(getStamentNameSpace("findItemAppTagsMasking"), queryMap);
	}

	@Override
	public List<Long> findItemInApp(Long appId, Boolean isOwner, Boolean deleted) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put(appIdKey, appId);
		queryMap.put("isOwner", isOwner);
		queryMap.put("deleted", deleted);
		return getSqlSession().selectList(getStamentNameSpace("findItemInApp"), queryMap);
	}

	@Override
	public List<Long> findItemSpecify(Long appId) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put(appIdKey, appId);
		return getSqlSession().selectList(getStamentNameSpace("findItemSpecify"), queryMap);
	}

}
