/**
 * Project Name:goods-center-api
 * File Name:RemoteGoodsBackendService.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice
 * Date:2016年6月14日上午11:50:19
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
 */

package cn.com.duiba.goods.center.biz.remoteservice.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.RemoteGoodsBackendService;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.goods.center.biz.bo.GoodsBackendBO;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 
 * 后台       商品中心
 * 
 * @author houwen
 *
 */
@Service("remoteGoodsBackendService")
public class RemoteGoodsBackendServiceImpl implements RemoteGoodsBackendService {
	
    private static Logger log=LoggerFactory.getLogger(RemoteGoodsBackendServiceImpl.class);

	@Autowired
	private GoodsBackendBO goodsBackendBO;
	
	@Override
	public DubboResult<GoodsStockDto> findGoodsStock(GoodsTypeEnum gtype, long gid) {
		try {
			GoodsStockDto stock = goodsBackendBO.findGoodsStock(gtype, gid);
			return DubboResult.successResult(stock);
		} catch (Exception e) {
			log.error("findGoodsStock gtype=" + gtype.getGtype() + ",gid=" + gid, e);
			return DubboResult.failResult(e.getMessage());
		}
	}
}
