package cn.com.duiba.goods.center.biz.remoteservice.item;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteItemKeyService;
import cn.com.duiba.goods.center.biz.service.item.ItemKeyService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * RemoteItemKeyServiceImpl
 */
@Service
public class RemoteItemKeyServiceImpl implements RemoteItemKeyService {

	private static final Logger LOGGER = LoggerFactory.getLogger(RemoteItemKeyServiceImpl.class);

	@Autowired
	private ItemKeyService itemKeyService;

	@Override
	public DubboResult<ItemKeyDto> findItemKey(Long appItemId, Long itemId, Long appId) {
		try {
			ItemKeyDto dto = itemKeyService.findItemKey(appItemId, itemId, appId);
			return DubboResult.successResult(dto);
		} catch (Exception e) {
			LOGGER.error("findItemKey:appItemId=" + appItemId + " itemId=" + itemId + " appId=" + appId, e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Long> findStock(ItemKeyDto itemKeyDto) {
		try {
			Long ret = itemKeyService.findStock(itemKeyDto);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			LOGGER.error("findStock:", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> consumeStock(ItemKeyDto itemKeyDto, String bizId, String bizSource) {
		try {
			Boolean ret = itemKeyService.consumeStock(itemKeyDto, bizId, bizSource);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			LOGGER.error("consumeStock:", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

	@Override
	public DubboResult<Boolean> rollbackStock(ItemKeyDto itemKeyDto, String bizId, String bizSource) {
		try {
			Boolean ret = itemKeyService.rollbackStock(itemKeyDto, bizId, bizSource);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			LOGGER.error("rollbackStock:", e);
			return DubboResult.failResult(e.getMessage());
		}
	}

}
