/**
 * Project Name:goods-center-biz File Name:GoodsCouponServiceImpl.java Package
 * Name:cn.com.duiba.goods.center.biz.service.impl Date:2016年5月25日下午1:08:07 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.goods.center.biz.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.GoodCouponRetrieveLogDto;
import cn.com.duiba.goods.center.biz.dao.GoodsCouponRetrieveLogDao;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponRetrieveLogEntity;
import cn.com.duiba.goods.center.biz.service.GoodsCouponRetrieveLogService;

/**
 * @Author zjd
 * @Date 16/8/15  
 */
@Service("goodsCouponRetrieveLogService")
public class GoodsCouponRetrieveLogServiceImpl implements GoodsCouponRetrieveLogService {

    @Autowired
    private GoodsCouponRetrieveLogDao goodsCouponRetrieveLogDao;
    @Override
    public Long create(GoodsCouponRetrieveLogEntity log) {
        return goodsCouponRetrieveLogDao.insert(log);
    }




    @Override
    public GoodCouponRetrieveLogDto find(Long id) {
        GoodsCouponRetrieveLogEntity entity = goodsCouponRetrieveLogDao.findById(id);
        if(entity!=null){
            GoodCouponRetrieveLogDto dto = new GoodCouponRetrieveLogDto();
            dto.setFileUrl(entity.getFileUrl());
            dto.setGoodsType(entity.getGoodsType());
            dto.setStatus(entity.getStatus());
            dto.setBatchId(entity.getBatchId());
            dto.setGid(entity.getGid());
            dto.setRecoveryAmount(entity.getRecoveryAmount());
            return dto;
        }
        return null;
    }

    @Override
    public boolean updateStatusSuccess(Long id,String filePath,int count) {
        return goodsCouponRetrieveLogDao.updateStatusSuccess(id,filePath,count);
    }

    @Override
    public boolean updateStatusPart(Long id,String filePath,int count) {
        return goodsCouponRetrieveLogDao.updateStatusPart(id,filePath,count);
    }

    @Override
    public boolean updateStatusFail(Long id) {
        return goodsCouponRetrieveLogDao.updateStatusFail(id);

    }

}
