package cn.com.duiba.goods.center.biz.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.dao.GoodsTagsDao;
import cn.com.duiba.goods.center.biz.entity.GoodsTagsEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsTagsService;
import cn.com.duiba.intersection.serivce.api.remoteservice.RemoteAppTagService;
import cn.com.duiba.intersection.serivce.api.remoteservice.dto.AppTagDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;

/**
 * GoodsTagsServiceImpl
 */
@Service("goodsTagsService")
public class GoodsTagsServiceImpl implements GoodsTagsService {

    private static final Logger LOGGER = LoggerFactory.getLogger(GoodsTagsServiceImpl.class);

    @Autowired
    private GoodsTagsDao goodsTagsDao;

    @Autowired
    private RemoteAppTagService remoteAppTagService;

    @Override
    public boolean savePCGTags(Long pcgId, String tags) {
        GoodsTagsEntity goodsTags = goodsTagsDao.selectByGidAndGtype(GoodsTypeEnum.PLATFORM.getGtype(), pcgId);
        if (goodsTags == null) {
            GoodsTagsEntity e4i = new GoodsTagsEntity();
            e4i.setGtype(GoodsTypeEnum.PLATFORM.getGtype());
            e4i.setGid(pcgId);
            e4i.setTags(tags);
            return goodsTagsDao.insert(e4i) > 0;
        }
        return goodsTagsDao.updateTagsById(goodsTags.getId(), tags) > 0;
    }

    @Override
    public GoodsTagsEntity selectByGidAndGtype(Integer gtype, Long gid) {
        return goodsTagsDao.selectByGidAndGtype(gtype,gid);
    }

    @Override
    public List<GoodsTagsEntity> findByPCGIds(List<Long> pcgIds) {
        if (pcgIds == null || pcgIds.isEmpty()) {
            return Collections.emptyList();
        }
        return goodsTagsDao.selectByGtypeAndGids(GoodsTypeEnum.PLATFORM.getGtype(), pcgIds);
    }

    @Override
    public List<Long> getPCGIdsByEntities(List<PlatformCouponGoodsEntity> pcgs) {
        if (pcgs == null) {
            return Collections.emptyList();
        }
        List<Long> pcgIds = new ArrayList<>();
        for (PlatformCouponGoodsEntity it : pcgs) {
            pcgIds.add(it.getPcgId());
        }
        return pcgIds;
    }

    @Override
    public Map<Long, String> getPCGTagsMapByIds(List<Long> pcgIds) {
        if (pcgIds == null || pcgIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List<GoodsTagsEntity> goodsTags = this.findByPCGIds(pcgIds);
        Map<Long, String> pcgTagsMap = new HashMap<>();
        for (GoodsTagsEntity it : goodsTags) {
            pcgTagsMap.put(it.getGid(), it.getTags());
        }
        return pcgTagsMap;
    }

    /**
     * 废弃原因:返回Long->String String拆解成List 匹配效率没有Set做交集运算高
     * 建议使用 Multimap<String,String> getPCGTagsMap(List<Long> pcgIds)
     * @param pcgs
     * @return
     */
    @Override
    public Map<Long, String> getPCGTagsMapByEntities(List<PlatformCouponGoodsEntity> pcgs) {
        List<Long> pcgIds = getPCGIdsByEntities(pcgs);
        return this.getPCGTagsMapByIds(pcgIds);
    }

    @Override
    public HashMultimap<Long,String> getPCGTagsMap(List<Long> pcgIds){
        HashMultimap<Long,String> maps = HashMultimap.create();
        if(pcgIds.isEmpty()){
            return maps;
        }
        Splitter spl = Splitter.on(",").trimResults().trimResults();
        List<GoodsTagsEntity> goodsTags = findByPCGIds(pcgIds);
        for(GoodsTagsEntity tag:goodsTags){
            if(StringUtils.isBlank(tag.getTags())){
                continue;
            }
            maps.putAll(tag.getGid(),spl.split(tag.getTags()));
        }
        return maps;
    }



    @Override
    public boolean containsAppTag(Long pcgId, Long appId) {
        GoodsTagsEntity goodsTagsEntity = goodsTagsDao.selectByGidAndGtype(GoodsTypeEnum.PLATFORM.getGtype(), pcgId);
        if (goodsTagsEntity == null || StringUtils.isBlank(goodsTagsEntity.getTags())) {
            return false;
        }
        List<String> appTags = this.getAppTags(appId);
        if (appTags == null || appTags.isEmpty()) {
            return false;
        }
        String[] pcgTags = goodsTagsEntity.getTags().split(",");
        List<String> pcgTagList = new ArrayList<>(Arrays.asList(pcgTags));
        pcgTagList.retainAll(appTags);
        return !pcgTagList.isEmpty();
    }

    @Override
    public List<String> getAppTags(Long appId) {
        DubboResult<AppTagDto> result = remoteAppTagService.getAppTagById(appId);
        if (!result.isSuccess()) {
            LOGGER.error("调用 tuia 获取 app 标签异常");
            return Collections.emptyList();
        }
        AppTagDto appTag = result.getResult();
        if (appTag == null) {
            return Collections.emptyList();
        }
        if (appTag.getAppId() == null || StringUtils.isBlank(appTag.getAppTags())) {
            return Collections.emptyList();
        }
        String[] tags = appTag.getAppTags().split(",");
        return new ArrayList<>(Arrays.asList(tags));
    }
}
