package cn.com.duiba.goods.center.biz.service.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.entity.CouponEntity;

/**
 * 优惠券service
 */
public interface CouponFlowService {

	/**
	 * <b>取一张优惠券</b> <br/>
	 * 
	 * 1:验证商品库存<br/>
	 * 2:验证商品对应批次是否可用<br/>
	 * 3:获取一张未锁定未使用的优惠券<br/>
	 * 4.更新批次库存<br/>
	 * 5.更新兑换项库存<br/>
	 * 如果该批次已经用完，执行下面流程 6.刷新批次信息<br/>
	 * 7.切换批次<br/>
	 * 8.更新兑换项批次引用<br/>
	 * 
	 * @param itemKey
	 */
	public CouponEntity getOneCoupon(ItemKeyDto itemKey);
	
	/**
	 * 完成一张券
	 * @param couponId
	 * @param orderId
	 */
	public void completeCoupon(Long couponId, Long orderId);

	/**
	 * <b>返还一张优惠券</b> <br/>
	 * 
	 * 1.验证优惠券锁定状态是否为true<br/>
	 * 2.设置优惠锁定状态为 false<br/>
	 * 3.更新批次库存<br/>
	 * 4.更新兑换项库存<br/>
	 * 如果该批次是未过期，且状态为已使用，执行下面流程 5.刷新批次信息<br/>
	 * 6.切换批次<br/>
	 * 7.更新兑换项批次引用<br/>
	 * @param couponId
	 */
	public void returnOneCoupon(long couponId);

	/**
	 * <b>删除优惠券批次</b> <br/>
	 * 1.开启事务 <br/>
	 * 2.删除批次 <br/>
	 * 3.删除批次优惠券 <br/>
	 * 4.更新批次库存<br/>
	 * 5.更新兑换项库存<br/>
	 * 6.刷新批次信息<br/>
	 * 7.切换批次<br/>
	 * 8.更新兑换项批次引用<br/>
	 * 9.更新兑换项最大过期时间<br/>
	 * 10.提交事务
	 * @param batchId
	 */
	public void deleteCouponBatch(long batchId) ;

	/**
	 * <b>删除优惠券券码</b> <br/>
	 * 1.开启事务 <br/>
	 * 2.删除优惠券券码 （未锁定，未领取）<br/>
	 * 3.更新批次库存<br/>
	 * 4.更新兑换项库存<br/>
	 * 5.刷新批次信息<br/>
	 * 6.切换批次<br/>
	 * 7.更新兑换项批次引用<br/>
	 * 8.更新兑换项最大过期时间<br/>
	 * 9.提交事务<br/>
	 *
	 * @param couponId
	 * @return
	 */
	public int deleteCouponCode(long couponId);

}
