package cn.com.duiba.goods.center.biz.service.item;

import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.ElasticGiftsItemShowDto;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.common.GoodsException;

/**
 * Created by gyf .
 * 16/10/17 .
 */
public interface ItemGoodsService {

    /**
     * 过滤并获取展示的 dtos
     * @param itemIds
     * @param appId
     * @param consumerId
     * @return
     * @throws GoodsException
     */
    List<ElasticGiftsItemShowDto> getItemsByElItemIds4Mobile(List<Long> itemIds, Long appId, Long consumerId) throws GoodsException;

    /**
     * 校验商品
     * @param itemId
     * @param appId
     * @param consumerId
     * @return
     */
    void checkElasticTakeOrder(Long itemId, Long appId, Long consumerId) throws GoodsException;
    
    /**
     * 通过ID查询兑吧商品
     * @param itemId
     * @return
     */
    ItemEntity find(Long itemId);
    
    /**
     * 修改启用，禁用
     * @param itemId
     * @param enable
     * @return
     */
    Boolean updateEnable(Long itemId, Boolean enable);

}
