package cn.com.duiba.goods.center.biz.service.item;

import java.util.Date;
import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;

/**
 * itemservice Created by gyf . 16/10/25 .
 */
public interface ItemService {

	/**
	 * 获取一个remaining 表示正确库存值的item 对象
	 * 
	 * @param id
	 * @return
	 */
	ItemEntity findCorrectStockItem(Long id);

	/**
	 * 根据ID查询应用商品信息
	 * 
	 * @param id
	 * @return
	 */
	public ItemEntity find(Long id);

	/**
	 * 根据ID集合查询应用商品信息
	 * 
	 * @param ids
	 * @return
	 */
	public List<ItemEntity> findByIds(List<Long> ids);

	/**
	 * 创建商品
	 * 
	 * @param itemEntity
	 * @return
	 */
	public Long insert(ItemEntity itemEntity);

	/**
	 * 修改商品
	 * 
	 * @param itemEntity
	 * @return
	 */
	public Boolean update(ItemEntity itemEntity);

	/**
	 * 删除商品
	 * 
	 * @param itemId
	 * @return
	 */
	public Boolean delete(Long itemId);

	/**
	 * 修改启用禁用
	 * 
	 * @param itemId
	 * @param enable
	 * @return
	 */
	public Boolean updateEnable(Long itemId, Boolean enable);

	/**
	 * 查询定向库存
	 * 
	 * @param appId
	 * @param itemId
	 * @return
	 */
	public Long findSpecifyRemaining(Long appId, Long itemId);

	/**
	 * 减一个库存
	 * 
	 * @param itemId
	 * @return
	 */
	public Boolean decrStock(Long itemId);

	/**
	 * 增加一个库存
	 * 
	 * @param itemId
	 * @return
	 */
	public Boolean incrStock(Long itemId);

	/**
	 * 编辑商品，增加库存
	 * 
	 * @param itemId
	 * @param number
	 * @return
	 */
	public Boolean appendStock(Long itemId, Long number);

	/**
	 * 编辑商品，减少库存
	 * 
	 * @param itemId
	 * @param number
	 * @return
	 */
	public Boolean deductStock(Long itemId, Long number);
	
	/**
	 * 修改库存和过期时间
	 * @param appItemId
	 * @param totalStock
	 * @param validEndDate
	 * @return
	 */
	public int updateRemainingAndvalidEndDate(Long itemId, Long totalStock, Date validEndDate);

	/**
	 * 查询兑吧自动推荐商品
	 * 
	 * @param appId
	 * @return
	 */
	public List<ItemEntity> findAutoRecommend(Long appId);

	/**
	 * 是否是直冲类商品
	 * 
	 * @param entity
	 * @return
	 */
	public Boolean isRechargeGoods(ItemEntity entity);
    
	/**
	 * 查询首页ItemDto
	 * @param itemIds
	 * @return
	 */
    public List<ItemDto> findHomeItems(List<Long> itemIds);
    
    /**
     * 移除缓存
     * @param itemId
     */
    public void removeCache(Long itemId);

}
