/**
 * Project Name:goods-center-biz
 * File Name:GoodsCouponBO.java
 * Package Name:cn.com.duiba.goods.center.biz.bo
 * Date:2016年5月24日下午4:38:28
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.bo;

import java.util.List;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;

/**
 * ClassName:GoodsCouponBO <br/>
 * Date:     2016年5月24日 下午4:38:28 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface GoodsCouponBO {

	/**
	 * 发券
	 * @param gtype
	 * @param gid
	 * @param consumerId
	 * @param bizNum
	 * @return
	 */
    public GoodsCouponEntity takeCoupon(GoodsTypeEnum gtype, long gid, long consumerId,String bizNum) ;
    
    /**
     * 发券
     * @param gtype
     * @param gid
     * @param consumerId
     * @param appId
     * @param bizNum
     * @return
     */
    public GoodsCouponEntity takeCoupon(GoodsTypeEnum gtype, long gid, Long consumerId, Long appId, String bizNum) ;

    /**
     * 完成券
     * @param couponId
     * @param orderId
     */
    public void completeCoupon(Long couponId, long orderId) ;

    /**
     * 回滚券
     * @param couponId
     * @param bizNum
     * @return
     */
    public Boolean rollbackCoupon(Long couponId,String bizNum) ;
    
    /**
     * 查询券
     * @param couponId
     * @return
     */
    public GoodsCouponEntity findCoupon(Long couponId);
    
    /**
     * 查询批次
     * @param goodsBatchId
     * @return
     */
    public GoodsBatchEntity findBatch(Long goodsBatchId);
    
    /**
     * 查询使用中的批次
     * @param gtype
     * @param gid
     * @return
     */
    public GoodsBatchEntity findUsingBatch(GoodsTypeEnum gtype, long gid);
    
    /**
     * 查询商品库存
     * @param gtype
     * @param gid
     * @return
     */
    public Long findGoodsStock(GoodsTypeEnum gtype, long gid);
    
    /**
     * 批量查询库存
     * @param goods
     * @return
     */
    public List<GoodsStockDto> findGoodsStockByBatch(List<GoodsStockDto> goods);
    
}

