package cn.com.duiba.goods.center.biz.bo;


import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFloorDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;

import java.util.List;

/**
 * PCGFilterConfigBO
 */
public interface PCGFilterConfigBO {
	
	/**
	 * findCategoryGoods
	 * @param appId
	 * @param categoryId
	 * @param consumerId
	 * @param consumerCredits
	 * @param pageIndex
	 * @param pageSize
	 * @return
	 */
	Page<PCGCategorySellerGoodsDto> findCategoryGoods(long appId,long categoryId,Long consumerId,Long consumerCredits, Integer pageIndex, Integer pageSize);
	
	/**
	 * findSellerGoods
	 * @param appId
	 * @param sellerId
	 * @param consumerId
	 * @param consumerCredits
	 * @param pageIndex
	 * @param pageSize
	 * @return
	 */
	Page<PCGCategorySellerGoodsDto> findSellerGoods(long appId,long sellerId,Long consumerId,Long consumerCredits, Integer pageIndex, Integer pageSize);
	
	/**
	 * checkBlack
	 * @param pcgIds
	 * @param appId
	 * @return
	 */
	List<Long> checkBlack(List<Long> pcgIds,Long appId);

	/**
	 * 获取楼层平台券内容
	 * @param appId
	 * @param size
	 * @return
	 */
	List<PCGFloorDto> findFloorPcgByAppId(Long appId,Integer size);

	/**
	 * 获取所有可展示的优惠券
	 * @param appId
	 * @param appTags
	 * @return
	 */
	List<PCGFloorDto> findAllPcg4Floor(Long appId, String appTags);
}
