/**
 * Project Name:goods-center-biz
 * File Name:GoodsContentEntityDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年5月19日下午8:36:26
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao;

import cn.com.duiba.goods.center.biz.entity.GoodsContentEntity;

/**
 * ClassName:GoodsContentEntityDao <br/>
 * Date:     2016年5月19日 下午8:36:26 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface GoodsContentDao {

	/**
	 * insert
	 * @param gtype
	 * @param gid
	 * @param content
	 * @return
	 */
    int insert(int gtype, long gid, String content);

    /**
     * updateContent
     * @param gtype
     * @param gid
     * @param content
     * @return
     */
    int updateContent(int gtype, long gid, String content);

    /**
     * select
     * @param gtype
     * @param gid
     * @return
     */
    GoodsContentEntity select(int gtype, long gid);

    /**
     * insertEx
     * @param gtype
     * @param gid
     * @param content
     * @param exchangeTips
     * @return
     */
    int insertEx(int gtype, long gid, String content, String exchangeTips);

    /**
     * updateEx
     * @param gtype
     * @param gid
     * @param content
     * @param exchangeTips
     * @return
     */
    int updateEx(int gtype, long gid, String content, String exchangeTips);
}

