package cn.com.duiba.goods.center.biz.dao.amb.impl;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.amb.AmbOrderFastDAO;
import cn.com.duiba.goods.center.biz.entity.amb.AmbOrderFastEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class AmbOrderFastDAOImpl extends BaseCreditsDao implements AmbOrderFastDAO {

	@Override
	public int insert(AmbOrderFastEntity fastOrder) {
		return this.sqlSession.insert(getStamentNameSpace("insert"), fastOrder);
	}

	@Override
	public int deleteByTypeAndOrderId(Long orderId, String orderFastType) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("orderId", orderId);
		paramMap.put("orderFastType", orderFastType);
		return this.sqlSession.delete(getStamentNameSpace("deleteByTypeAndOrderId"), paramMap);
	}

	@Override
	public int deleteByOrderId(Long orderId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("orderId", orderId);
		return this.sqlSession.delete(getStamentNameSpace("deleteByOrderId"), paramMap);
	}

	@Override
	public AmbOrderFastEntity findForUpdate(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return this.sqlSession.selectOne(getStamentNameSpace("findForUpdate"), paramMap);
	}

	@Override
	public AmbOrderFastEntity findByOrderIdAndType(Long orderId, String orderFastType) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("orderId", orderId);
		paramMap.put("orderFastType", orderFastType);
		return this.sqlSession.selectOne(getStamentNameSpace("findByOrderIdAndType"), paramMap);
	}

	@Override
	public List<AmbOrderFastEntity> findByTypeAndScanTime(String orderFastType) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("orderFastType", orderFastType);
		return this.sqlSession.selectList(getStamentNameSpace("findByTypeAndScanTime"), paramMap);
	}

}
