package cn.com.duiba.goods.center.biz.dao.amb.impl;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.amb.AmbPaychannelOrdersDAO;
import cn.com.duiba.goods.center.biz.entity.amb.AmbPaychannelOrdersEntity;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.Map;

@Repository
public class AmbPaychannelOrdersDAOImpl extends BaseCreditsDao implements
		AmbPaychannelOrdersDAO
{

	@Override
	public int createAmbPayChannelOrder(AmbPaychannelOrdersEntity pay)
	{
		return sqlSession.insert(getStamentNameSpace("createAmbPayChannelOrder"), pay);
	}

	/** 按子定单ID去更新 支付通道相关信息 **/
	@Override
	public int updatePayChannel4SuccessByIdAndWaitPay(Long id, String tradeNum)
	{

		Map<String, Object> params = Maps.newHashMap();

		params.put("channelId", id);
		params.put("tradeNum", tradeNum);

		return sqlSession.update(getStamentNameSpace("updatePayChannel4SuccessByIdAndWaitPay"), params);
	}
	
	@Override
	public int updatePayChannelTradeNumByIdAndWaitPay(Long id, String tradeNum)
	{

		Map<String, Object> params = Maps.newHashMap();

		params.put("channelId", id);
		params.put("tradeNum", tradeNum);

		return sqlSession.update(getStamentNameSpace("updatePayChannelTradeNumByIdAndWaitPay"), params);
	}


	@Override
	public int updatePayBackMoneyByIdAndStatusSuccess(Long id, Long money)
	{
		Map<String, Object> params = Maps.newHashMap();

		params.put("channelId", id);
		params.put("money", money);

		return sqlSession.update(getStamentNameSpace("updatePayBackMoneyByIdAndStatusSuccess"), params);

	}

	@Override
	public AmbPaychannelOrdersEntity findById(Long id)
	{
		return sqlSession.selectOne(getStamentNameSpace("findById"), id);
	}
}
