package cn.com.duiba.goods.center.biz.dao.amb.impl;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.amb.AmbPostsaleOrderFasterDAO;
import cn.com.duiba.goods.center.biz.entity.amb.AmbPostsaleOrderFasterEntity;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service("ambPostsaleOrderFasterDAO")
public class AmbPostsaleOrderFasterDAOImpl extends BaseCreditsDao implements AmbPostsaleOrderFasterDAO {

	@Override
	public void insert(AmbPostsaleOrderFasterEntity ambPostsaleOrderFaster) {
		this.sqlSession.insert(getStamentNameSpace("insert"), ambPostsaleOrderFaster);
	}

	@Override
	public AmbPostsaleOrderFasterEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return this.sqlSession.selectOne(getStamentNameSpace("find"), paramMap);
	}

	@Override
	public void updatePostsaleStatusByPostsaleOrderId(Long postsaleOrderId, String postsaleStatus) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("postsaleOrderId", postsaleOrderId);
		paramMap.put("postsaleStatus", postsaleStatus);
		this.sqlSession.update(getStamentNameSpace("updatePostsaleStatusByPostsaleOrderId"), paramMap);
	}

	@Override
	public void updatePostsaleById(Long id, Long ambPostsaleOrderId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("ambPostsaleOrderId", ambPostsaleOrderId);
		this.sqlSession.update(getStamentNameSpace("updatePostsaleById"), paramMap);
	}

	@Override
	public AmbPostsaleOrderFasterEntity findByOrderId(Long orderId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("orderId", orderId);
		return this.sqlSession.selectOne(getStamentNameSpace("findByOrderId"), paramMap);
	}

}
