package cn.com.duiba.goods.center.biz.dao.amb.impl;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.amb.AmbPostsaleOrdersDAO;
import cn.com.duiba.goods.center.biz.entity.amb.AmbPostsaleOrdersEntity;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Repository("ambPostsaleOrdersDAO")
public class AmbPostsaleOrdersDAOImpl extends BaseCreditsDao implements AmbPostsaleOrdersDAO {

	@Override
	public AmbPostsaleOrdersEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return this.sqlSession.selectOne(getStamentNameSpace("find"), paramMap);
	}

	@Override
	public void insert(AmbPostsaleOrdersEntity ambPostsaleOrders) {
		this.sqlSession.insert(getStamentNameSpace("insert"), ambPostsaleOrders);
	}

	@Override
	public void update(AmbPostsaleOrdersEntity ambPostsaleOrders) {
		this.sqlSession.update(getStamentNameSpace("update"), ambPostsaleOrders);
	}

	@Override
	public AmbPostsaleOrdersEntity findByOrderId(Long orderId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("orderId", orderId);
		return this.sqlSession.selectOne(getStamentNameSpace("findByOrderId"), paramMap);
	}

	@Override
	public void doAgree(Long id, String operateRemark, Date operateTime) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("operateRemark", operateRemark);
		paramMap.put("operateTime", operateTime);
		this.sqlSession.update(getStamentNameSpace("doAgree"), paramMap);
	}

	@Override
	public void doReject(Long id, String operateRemark, Date operateTime, Date finishTime) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("operateRemark", operateRemark);
		paramMap.put("operateTime", operateTime);
		paramMap.put("finishTime", finishTime);
		this.sqlSession.update(getStamentNameSpace("doReject"), paramMap);
	}

	@Override
	public void doCancel(Long id, Date finishTime) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("finishTime", finishTime);
		this.sqlSession.update(getStamentNameSpace("doCancel"), paramMap);
	}

	@Override
	public void doComplete(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		this.sqlSession.update(getStamentNameSpace("doComplete"), paramMap);
	}

	@Override
	public void doSuccess(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		this.sqlSession.update(getStamentNameSpace("doSuccess"), paramMap);
	}

	@Override
	public AmbPostsaleOrdersEntity findForUpdate(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return this.sqlSession.selectOne(getStamentNameSpace("findForUpdate"), paramMap);
	}

}
