package cn.com.duiba.goods.center.biz.dao.amb.impl;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.amb.AmbSubOrdersDAO;
import cn.com.duiba.goods.center.biz.entity.amb.AmbSubOrdersEntity;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository("ambSubOrdersDAO")
public class AmbSubOrdersDAOImpl extends BaseCreditsDao implements
		AmbSubOrdersDAO
{

	@Override
	public int createSubOrders(AmbSubOrdersEntity order)
	{
		return sqlSession.insert(getStamentNameSpace("createSubOrders"), order);
	}

	@Override
	public AmbSubOrdersEntity findSubOrderById(Long subId)
	{

		return sqlSession.selectOne(getStamentNameSpace("findSubOrderById"), subId);
	}

	@Override
	public int updatePayChannelIdBySubId(Long payChannelId, Long id)
	{

		Map<String, Long> params = Maps.newHashMap();

		params.put("payChannelId", payChannelId);
		params.put("subId", id);
		return sqlSession.update(getStamentNameSpace("updatePayChannelIdBySubId"), params);
	}

	@Override
	public int updateSettleStatusNoneBySubId(Long subId, Long consumerPayBackPrice)
	{
		Map<String, Long> params = Maps.newHashMap();

		params.put("consumerPayBackPrice", consumerPayBackPrice);
		params.put("subId", subId);

		return sqlSession.update(getStamentNameSpace("updateSettleStatusNoneBySubId"), params);
	}

	@Override
	public int updateSettleStatusSettleBySubId(Long subId)
	{

		return sqlSession.update(getStamentNameSpace("updateSettleStatusSettleBySubId"), subId);
	}

	@Override
	public int updateSettleStatusWaitSettleBySubId(Long subId)
	{

		return sqlSession.update(getStamentNameSpace("updateSettleStatusWaitSettleBySubId"), subId);
	}

	@Override
	public int updateShipStatus4WaitShip(Long subId)
	{
		return sqlSession.update(getStamentNameSpace("updateShipStatus4WaitShip"), subId);
	}

	@Override
	public int updateShipStatus4Shiped(Long subId)
	{
		return sqlSession.update(getStamentNameSpace("updateShipStatus4Shiped"), subId);
	}

	@Override
	public int updateShipStatus4Received(Long subId)
	{
		return sqlSession.update(getStamentNameSpace("updateShipStatus4Received"), subId);
	}

	// @Override
	// public int updateShipStatus4Cancled(Long subId)
	// {
	// return sqlSession.update(getStamentNameSpace("updateShipStatus4Cancled"),
	// subId);
	//
	// }

	@Override
	public int updateRemarkBySubId(Long subId, String remark)
	{
		Map<String, Object> params = Maps.newHashMap();

		params.put("remark", remark);
		params.put("subId", subId);
		return sqlSession.update(getStamentNameSpace("updateRemarkBySubId"), params);
	}

	@Override
	public List<AmbSubOrdersEntity> findByIds(List<Long> Ids)
	{
		Map<String, Object> params = Maps.newHashMap();
		params.put("Ids", Ids);
		return sqlSession.selectList(getStamentNameSpace("findSubOrderById"), params);
	}

	public int updateAmbPostsaleOrderIdById(Long subId, Long postsaleOrderId)
	{
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("subId", subId);
		params.put("postsaleOrderId", postsaleOrderId);
		return sqlSession.update(getStamentNameSpace("updateAmbPostsaleOrderIdById"), params);
	}

	@Override
	public int updateConsumerPayBackPriceById(Long id, Long consumerPayBackPrice)
	{
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("id", id);
		params.put("consumerPayBackPrice", consumerPayBackPrice);
		return sqlSession.update(getStamentNameSpace("updateConsumerPayBackPriceById"), params);
	}

	/**
 * 有些商品不走发货  流程，付款后直接变成收货
 */
	@Override
	public int updateShipStatus4ReceivedAtCreate(Long subId)
	{
		return sqlSession.update(getStamentNameSpace("updateShipStatus4ReceivedAtCreate"), subId);
	}
}
