package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.AppItemDao;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;

/**
 * 
 * AppItemDaoImpl
 *
 */
@Repository("appItemDao")
public class AppItemDaoImpl extends BaseCreditsDao implements AppItemDao {
	
	private String appIdKey = "appId";
	private String statusKey = "status";

	@Override
	public AppItemEntity find(Long id) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("id", id);
		return getSqlSession().selectOne(getStamentNameSpace("find"), queryMap);
	}

	@Override
	public List<AppItemEntity> findByIds(List<Long> ids) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("ids", ids);
		return getSqlSession().selectList(getStamentNameSpace("findByIds"), queryMap);
	}

	@Override
	public void insert(AppItemEntity appItemEntity) {
		getSqlSession().insert(getStamentNameSpace("insert"), appItemEntity);
	}

	@Override
	public Integer update(AppItemEntity appItemEntity) {
		return getSqlSession().update(getStamentNameSpace("update"), appItemEntity);
	}

	@Override
	public Integer delete(Long appId, Long id) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put(appIdKey, appId);
		queryMap.put("id", id);
		return getSqlSession().update(getStamentNameSpace("delete"), queryMap);
	}

	@Override
	public Integer deleteByIds(Long appId, List<Long> ids) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put(appIdKey, appId);
		queryMap.put("ids", ids);
		return getSqlSession().update(getStamentNameSpace("deleteByIds"), queryMap);
	}

	@Override
	public Integer updateStatus(Long appId, Long id, String status) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put(appIdKey, appId);
		queryMap.put("id", id);
		queryMap.put(statusKey, status);
		return getSqlSession().update(getStamentNameSpace("updateStatus"), queryMap);
	}

	@Override
	public Integer updateStatusByIds(Long appId, List<Long> ids, String status) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put(appIdKey, appId);
		queryMap.put("ids", ids);
		queryMap.put(statusKey, status);
		return getSqlSession().update(getStamentNameSpace("updateStatusByIds"), queryMap);
	}
	
	@Override
	public Integer decrStock(Long id) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("id", id);
		return getSqlSession().update(getStamentNameSpace("decrStock"), queryMap);
	}

	@Override
	public Integer incrStock(Long id) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("id", id);
		return getSqlSession().update(getStamentNameSpace("incrStock"), queryMap);
	}

	@Override
	public Integer appendStock(Long id, Long number) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("id", id);
		queryMap.put("number", number);
		return getSqlSession().update(getStamentNameSpace("incrStock"), queryMap);
	}

	@Override
	public Integer deductStock(Long id, Long number) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("id", id);
		queryMap.put("number", number);
		return getSqlSession().update(getStamentNameSpace("deductStock"), queryMap);
	}

	@Override
	public AppItemEntity findByAppIdAndItemId(Long appId, Long itemId) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put(appIdKey, appId);
		queryMap.put("itemId", itemId);
		return getSqlSession().selectOne(getStamentNameSpace("findByAppIdAndItemId"), queryMap);
	}

	@Override
	public Integer updateRemainingAndvalidEndDate(Long appItemId, Long totalStock, Date validEndDate) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("id", appItemId);
		queryMap.put("totalStock", totalStock);
		queryMap.put("validEndDate", validEndDate);
		return getSqlSession().update(getStamentNameSpace("updateRemainingAndvalidEndDate"), queryMap);
	}
	
	@Override
	public Integer updateExpiedAppItem(Long itemId){
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("itemId", itemId);
		return getSqlSession().update(getStamentNameSpace("updateExpiedAppItem"), queryMap);
	}
	
	@Override
	public Integer updateExpiedAppItemById(Long appItemId){
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("appItemId", appItemId);
		return getSqlSession().update(getStamentNameSpace("updateExpiedAppItemById"), queryMap);
	}

    @Override
    public List<AppItemDto> findhomeAppItemNeed(Long appId) {
        return getSqlSession().selectList(this.getStamentNameSpace("findhomeAppItemNeed"), appId);
    }

    @Override
    public List<Long> findAppIdsByInActivityId(Long activityId, Integer type) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("activityId", activityId);
        paramMap.put("type", type);
        return getSqlSession().selectList(this.getStamentNameSpace("findAppIdsByInActivityId"), paramMap);
    }

    @Override
    public List<Long> findAppIdsByActivityId(Long relationId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("relationId", relationId);
        return getSqlSession().selectList(this.getStamentNameSpace("findAppIdsByActivityId"), paramMap);
    }
    
    @Override
    public List<Long> findIdsByActivityIds(List<Long> relationIds) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("relationIds", relationIds);
        return getSqlSession().selectList(this.getStamentNameSpace("findIdsByActivityIds"), paramMap);
    }

    @Override
    public List<Long> findAppIdByItemIds(List<Long> itemIds) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("itemIds", itemIds);
        return getSqlSession().selectList(this.getStamentNameSpace("findAppIdByItemIds"), paramMap);
    }

    @Override
    public List<AppItemDto> findAppItemsByAppIdAndIds(Long appId, String status, List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("appId", appId);
        paramMap.put(statusKey,status);
        paramMap.put("ids", ids);
        return getSqlSession().selectList(this.getStamentNameSpace("findAppItemsByAppIdAndIds"), paramMap);
    }

    @Override
    public List<Long> findAppIdsByIds(List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("ids", ids);
        return getSqlSession().selectList(this.getStamentNameSpace("findAppIdsByIds"), paramMap);
    }

	@Override
	public List<Long> findIdByItemId(Long itemId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("itemId", itemId);
		return getSqlSession().selectList(this.getStamentNameSpace("findIdByItemId"), paramMap);
	}

	@Override
	public int updateStatusByActivityIds(String status, Boolean delete, List<Long> oids) {
	    Map<String, Object> queryMap = new HashMap<>();
        queryMap.put("status", status);
        queryMap.put("delete", delete);
        queryMap.put("oids", oids);
        return getSqlSession().update(getStamentNameSpace("updateStatusByActivityIds"), queryMap);
	}
}
