package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemExtraDao;
import cn.com.duiba.goods.center.biz.entity.ItemExtraEntity;

/**
 * ItemAutoRecommendDaoImpl
 */
@Repository("itemExtraDAO")
public class ItemExtraDaoImpl extends BaseCreditsDao implements ItemExtraDao {

    @Override
    public ItemExtraEntity findByItemId(Long itemId) {
        Map<String, Object> map = new HashMap<>();
        map.put("itemId", itemId);
        return getSqlSession().selectOne(getStamentNameSpace("findByItemId"), map);
    }

    @Override
    public List<ItemExtraEntity> findByItemIds(List<Long> itemIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("itemIds", itemIds);
        return getSqlSession().selectList(getStamentNameSpace("findByItemIds"), map);
    }

    @Override
    public List<ItemExtraEntity> findByName4Admin(String name) {
        Map<String, Object> map = new HashMap<>();
        map.put("name", name);
        return getSqlSession().selectList(getStamentNameSpace("findByName4Admin"), map);
    }

    @Override
    public List<ItemExtraEntity> findAll() {
        return getSqlSession().selectList(getStamentNameSpace("findAll"));
    }

    @Override
    public void insert(ItemExtraEntity itemExtra) {
        getSqlSession().insert(getStamentNameSpace("insert"), itemExtra);
    }

    @Override
    public void update(ItemExtraEntity itemExtra) {
        getSqlSession().update(getStamentNameSpace("update"), itemExtra);
    }

}
